/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.crypto.ec;

import java.math.BigInteger;
import thirdparty.bouncycastle.crypto.CipherParameters;
import thirdparty.bouncycastle.crypto.ec.ECPair;
import thirdparty.bouncycastle.crypto.ec.ECPairFactorTransform;
import thirdparty.bouncycastle.crypto.params.ECDomainParameters;
import thirdparty.bouncycastle.crypto.params.ECPublicKeyParameters;
import thirdparty.bouncycastle.math.ec.ECAlgorithms;
import thirdparty.bouncycastle.math.ec.ECMultiplier;
import thirdparty.bouncycastle.math.ec.ECPoint;
import thirdparty.bouncycastle.math.ec.FixedPointCombMultiplier;

public class ECFixedTransform
implements ECPairFactorTransform {
    private ECPublicKeyParameters key;
    private BigInteger k;

    public ECFixedTransform(BigInteger bigInteger) {
        this.k = bigInteger;
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof ECPublicKeyParameters)) {
            throw new IllegalArgumentException("ECPublicKeyParameters are required for fixed transform.");
        }
        this.key = (ECPublicKeyParameters)cipherParameters;
    }

    @Override
    public ECPair transform(ECPair eCPair) {
        if (this.key == null) {
            throw new IllegalStateException("ECFixedTransform not initialised");
        }
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        BigInteger bigInteger = eCDomainParameters.getN();
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        BigInteger bigInteger2 = this.k.mod(bigInteger);
        ECPoint[] eCPointArray = new ECPoint[]{eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger2).add(ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPair.getX())), this.key.getQ().multiply(bigInteger2).add(ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPair.getY()))};
        eCDomainParameters.getCurve().normalizeAll(eCPointArray);
        return new ECPair(eCPointArray[0], eCPointArray[1]);
    }

    @Override
    public BigInteger getTransformValue() {
        return this.k;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

