/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.crypto.generators;

import java.math.BigInteger;
import thirdparty.bouncycastle.crypto.AsymmetricCipherKeyPair;
import thirdparty.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import thirdparty.bouncycastle.crypto.CryptoServicePurpose;
import thirdparty.bouncycastle.crypto.CryptoServicesRegistrar;
import thirdparty.bouncycastle.crypto.KeyGenerationParameters;
import thirdparty.bouncycastle.crypto.constraints.ConstraintUtils;
import thirdparty.bouncycastle.crypto.constraints.DefaultServiceProperties;
import thirdparty.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import thirdparty.bouncycastle.crypto.params.DHParameters;
import thirdparty.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import thirdparty.bouncycastle.crypto.params.ElGamalParameters;
import thirdparty.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import thirdparty.bouncycastle.crypto.params.ElGamalPublicKeyParameters;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (ElGamalKeyGenerationParameters)keyGenerationParameters;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("ElGamalKeyGen", ConstraintUtils.bitsOfSecurityFor(this.param.getParameters().getP()), this.param.getParameters(), CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters elGamalParameters = this.param.getParameters();
        DHParameters dHParameters = new DHParameters(elGamalParameters.getP(), elGamalParameters.getG(), null, elGamalParameters.getL());
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(bigInteger2, elGamalParameters), new ElGamalPrivateKeyParameters(bigInteger, elGamalParameters));
    }
}

