/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import thirdparty.bouncycastle.crypto.AsymmetricCipherKeyPair;
import thirdparty.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import thirdparty.bouncycastle.crypto.CryptoServicePurpose;
import thirdparty.bouncycastle.crypto.CryptoServicesRegistrar;
import thirdparty.bouncycastle.crypto.KeyGenerationParameters;
import thirdparty.bouncycastle.crypto.constraints.ConstraintUtils;
import thirdparty.bouncycastle.crypto.constraints.DefaultServiceProperties;
import thirdparty.bouncycastle.crypto.params.GOST3410KeyGenerationParameters;
import thirdparty.bouncycastle.crypto.params.GOST3410Parameters;
import thirdparty.bouncycastle.crypto.params.GOST3410PrivateKeyParameters;
import thirdparty.bouncycastle.crypto.params.GOST3410PublicKeyParameters;
import thirdparty.bouncycastle.math.ec.WNafUtil;
import thirdparty.bouncycastle.util.BigIntegers;

public class GOST3410KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private GOST3410KeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (GOST3410KeyGenerationParameters)keyGenerationParameters;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("GOST3410KeyGen", ConstraintUtils.bitsOfSecurityFor(this.param.getParameters().getP()), this.param.getParameters(), CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        GOST3410Parameters gOST3410Parameters = this.param.getParameters();
        SecureRandom secureRandom = this.param.getRandom();
        BigInteger bigInteger2 = gOST3410Parameters.getQ();
        BigInteger bigInteger3 = gOST3410Parameters.getP();
        BigInteger bigInteger4 = gOST3410Parameters.getA();
        int n = 64;
        while ((bigInteger = BigIntegers.createRandomBigInteger(256, secureRandom)).signum() < 1 || bigInteger.compareTo(bigInteger2) >= 0 || WNafUtil.getNafWeight(bigInteger) < n) {
        }
        BigInteger bigInteger5 = bigInteger4.modPow(bigInteger, bigInteger3);
        return new AsymmetricCipherKeyPair(new GOST3410PublicKeyParameters(bigInteger5, gOST3410Parameters), new GOST3410PrivateKeyParameters(bigInteger, gOST3410Parameters));
    }
}

