/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.crypto.generators;

import java.security.SecureRandom;
import thirdparty.bouncycastle.crypto.AsymmetricCipherKeyPair;
import thirdparty.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import thirdparty.bouncycastle.crypto.CryptoServicePurpose;
import thirdparty.bouncycastle.crypto.CryptoServicesRegistrar;
import thirdparty.bouncycastle.crypto.KeyGenerationParameters;
import thirdparty.bouncycastle.crypto.constraints.DefaultServiceProperties;
import thirdparty.bouncycastle.crypto.params.X448PrivateKeyParameters;
import thirdparty.bouncycastle.crypto.params.X448PublicKeyParameters;

public class X448KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("X448KeyGen", 224, null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        X448PrivateKeyParameters x448PrivateKeyParameters = new X448PrivateKeyParameters(this.random);
        X448PublicKeyParameters x448PublicKeyParameters = x448PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(x448PublicKeyParameters, x448PrivateKeyParameters);
    }
}

