/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.dvcs;

import java.io.OutputStream;
import thirdparty.bouncycastle.asn1.x509.DigestInfo;
import thirdparty.bouncycastle.dvcs.DVCSException;
import thirdparty.bouncycastle.dvcs.MessageImprint;
import thirdparty.bouncycastle.operator.DigestCalculator;

public class MessageImprintBuilder {
    private final DigestCalculator digestCalculator;

    public MessageImprintBuilder(DigestCalculator digestCalculator) {
        this.digestCalculator = digestCalculator;
    }

    public MessageImprint build(byte[] byArray) throws DVCSException {
        try {
            OutputStream outputStream = this.digestCalculator.getOutputStream();
            outputStream.write(byArray);
            outputStream.close();
            return new MessageImprint(new DigestInfo(this.digestCalculator.getAlgorithmIdentifier(), this.digestCalculator.getDigest()));
        }
        catch (Exception exception) {
            throw new DVCSException("unable to build MessageImprint: " + exception.getMessage(), exception);
        }
    }
}

