/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.dvcs;

import java.io.IOException;
import thirdparty.bouncycastle.cms.CMSException;
import thirdparty.bouncycastle.cms.CMSProcessableByteArray;
import thirdparty.bouncycastle.cms.CMSSignedData;
import thirdparty.bouncycastle.cms.CMSSignedDataGenerator;
import thirdparty.bouncycastle.dvcs.DVCSException;
import thirdparty.bouncycastle.dvcs.DVCSMessage;

public class SignedDVCSMessageGenerator {
    private final CMSSignedDataGenerator signedDataGen;

    public SignedDVCSMessageGenerator(CMSSignedDataGenerator cMSSignedDataGenerator) {
        this.signedDataGen = cMSSignedDataGenerator;
    }

    public CMSSignedData build(DVCSMessage dVCSMessage) throws DVCSException {
        try {
            byte[] byArray = dVCSMessage.getContent().toASN1Primitive().getEncoded("DER");
            return this.signedDataGen.generate(new CMSProcessableByteArray(dVCSMessage.getContentType(), byArray), true);
        }
        catch (CMSException cMSException) {
            throw new DVCSException("Could not sign DVCS request", cMSException);
        }
        catch (IOException iOException) {
            throw new DVCSException("Could not encode DVCS request", iOException);
        }
    }
}

