/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.its;

import java.io.IOException;
import java.io.OutputStream;
import thirdparty.bouncycastle.its.ITSPublicEncryptionKey;
import thirdparty.bouncycastle.its.ITSValidityPeriod;
import thirdparty.bouncycastle.its.operator.ECDSAEncoder;
import thirdparty.bouncycastle.its.operator.ITSContentVerifierProvider;
import thirdparty.bouncycastle.oer.OEREncoder;
import thirdparty.bouncycastle.oer.its.ieee1609dot2.CertificateBase;
import thirdparty.bouncycastle.oer.its.ieee1609dot2.IssuerIdentifier;
import thirdparty.bouncycastle.oer.its.ieee1609dot2.basetypes.PublicEncryptionKey;
import thirdparty.bouncycastle.oer.its.ieee1609dot2.basetypes.Signature;
import thirdparty.bouncycastle.oer.its.template.ieee1609dot2.IEEE1609dot2;
import thirdparty.bouncycastle.operator.ContentVerifier;
import thirdparty.bouncycastle.util.Encodable;

public class ITSCertificate
implements Encodable {
    private final CertificateBase certificate;

    public ITSCertificate(CertificateBase certificateBase) {
        this.certificate = certificateBase;
    }

    public IssuerIdentifier getIssuer() {
        return this.certificate.getIssuer();
    }

    public ITSValidityPeriod getValidityPeriod() {
        return new ITSValidityPeriod(this.certificate.getToBeSigned().getValidityPeriod());
    }

    public ITSPublicEncryptionKey getPublicEncryptionKey() {
        PublicEncryptionKey publicEncryptionKey = this.certificate.getToBeSigned().getEncryptionKey();
        if (publicEncryptionKey != null) {
            return new ITSPublicEncryptionKey(publicEncryptionKey);
        }
        return null;
    }

    public boolean isSignatureValid(ITSContentVerifierProvider iTSContentVerifierProvider) throws Exception {
        ContentVerifier contentVerifier = iTSContentVerifierProvider.get(this.certificate.getSignature().getChoice());
        OutputStream outputStream = contentVerifier.getOutputStream();
        outputStream.write(OEREncoder.toByteArray(this.certificate.getToBeSigned(), IEEE1609dot2.ToBeSignedCertificate.build()));
        outputStream.close();
        Signature signature = this.certificate.getSignature();
        return contentVerifier.verify(ECDSAEncoder.toX962(signature));
    }

    public CertificateBase toASN1Structure() {
        return this.certificate;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return OEREncoder.toByteArray(this.certificate, IEEE1609dot2.CertificateBase.build());
    }
}

