/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.jcajce.provider.digest;

import thirdparty.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import thirdparty.bouncycastle.crypto.CipherKeyGenerator;
import thirdparty.bouncycastle.crypto.digests.RIPEMD128Digest;
import thirdparty.bouncycastle.crypto.macs.HMac;
import thirdparty.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import thirdparty.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import thirdparty.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import thirdparty.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import thirdparty.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class RIPEMD128 {
    private RIPEMD128() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new RIPEMD128Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new RIPEMD128Digest((RIPEMD128Digest)this.digest);
            return digest;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new RIPEMD128Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACRIPEMD128", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = RIPEMD128.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.RIPEMD128", PREFIX + "$Digest");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest." + TeleTrusTObjectIdentifiers.ripemd128, "RIPEMD128");
            this.addHMACAlgorithm(configurableProvider, "RIPEMD128", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }
}

