/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.jcajce.provider.symmetric;

import thirdparty.bouncycastle.crypto.CipherKeyGenerator;
import thirdparty.bouncycastle.crypto.engines.HC256Engine;
import thirdparty.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import thirdparty.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import thirdparty.bouncycastle.jcajce.provider.symmetric.util.BaseStreamCipher;
import thirdparty.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import thirdparty.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class HC256 {
    private HC256() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "HC256 IV";
        }
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new HC256Engine(), 32);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("HC256", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = HC256.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.HC256", PREFIX + "$Base");
            configurableProvider.addAlgorithm("KeyGenerator.HC256", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.HC256", PREFIX + "$AlgParams");
        }
    }
}

