/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.jcajce.provider.symmetric;

import thirdparty.bouncycastle.crypto.BlockCipher;
import thirdparty.bouncycastle.crypto.CipherKeyGenerator;
import thirdparty.bouncycastle.crypto.engines.RijndaelEngine;
import thirdparty.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import thirdparty.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import thirdparty.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import thirdparty.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import thirdparty.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import thirdparty.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class Rijndael {
    private Rijndael() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Rijndael IV";
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                @Override
                public BlockCipher get() {
                    return new RijndaelEngine();
                }
            });
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Rijndael", 192, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Rijndael.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.RIJNDAEL", PREFIX + "$ECB");
            configurableProvider.addAlgorithm("KeyGenerator.RIJNDAEL", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.RIJNDAEL", PREFIX + "$AlgParams");
        }
    }
}

