/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.jcajce.provider.symmetric;

import thirdparty.bouncycastle.crypto.CipherKeyGenerator;
import thirdparty.bouncycastle.crypto.engines.XSalsa20Engine;
import thirdparty.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import thirdparty.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import thirdparty.bouncycastle.jcajce.provider.symmetric.util.BaseStreamCipher;
import thirdparty.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import thirdparty.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class XSalsa20 {
    private XSalsa20() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "XSalsa20 IV";
        }
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new XSalsa20Engine(), 24);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("XSalsa20", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = XSalsa20.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.XSALSA20", PREFIX + "$Base");
            configurableProvider.addAlgorithm("KeyGenerator.XSALSA20", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.XSALSA20", PREFIX + "$AlgParams");
        }
    }
}

