/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.math.ec.endo;

import java.math.BigInteger;
import thirdparty.bouncycastle.math.ec.ECCurve;
import thirdparty.bouncycastle.math.ec.ECPointMap;
import thirdparty.bouncycastle.math.ec.ScaleYNegateXPointMap;
import thirdparty.bouncycastle.math.ec.endo.EndoUtil;
import thirdparty.bouncycastle.math.ec.endo.GLVEndomorphism;
import thirdparty.bouncycastle.math.ec.endo.GLVTypeAParameters;

public class GLVTypeAEndomorphism
implements GLVEndomorphism {
    protected final GLVTypeAParameters parameters;
    protected final ECPointMap pointMap;

    public GLVTypeAEndomorphism(ECCurve eCCurve, GLVTypeAParameters gLVTypeAParameters) {
        this.parameters = gLVTypeAParameters;
        this.pointMap = new ScaleYNegateXPointMap(eCCurve.fromBigInteger(gLVTypeAParameters.getI()));
    }

    @Override
    public BigInteger[] decomposeScalar(BigInteger bigInteger) {
        return EndoUtil.decomposeScalar(this.parameters.getSplitParams(), bigInteger);
    }

    @Override
    public ECPointMap getPointMap() {
        return this.pointMap;
    }

    @Override
    public boolean hasEfficientPointMap() {
        return true;
    }
}

