/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.math.ec.endo;

import java.math.BigInteger;
import thirdparty.bouncycastle.math.ec.ECCurve;
import thirdparty.bouncycastle.math.ec.ECPointMap;
import thirdparty.bouncycastle.math.ec.ScaleXPointMap;
import thirdparty.bouncycastle.math.ec.endo.EndoUtil;
import thirdparty.bouncycastle.math.ec.endo.GLVEndomorphism;
import thirdparty.bouncycastle.math.ec.endo.GLVTypeBParameters;

public class GLVTypeBEndomorphism
implements GLVEndomorphism {
    protected final GLVTypeBParameters parameters;
    protected final ECPointMap pointMap;

    public GLVTypeBEndomorphism(ECCurve eCCurve, GLVTypeBParameters gLVTypeBParameters) {
        this.parameters = gLVTypeBParameters;
        this.pointMap = new ScaleXPointMap(eCCurve.fromBigInteger(gLVTypeBParameters.getBeta()));
    }

    @Override
    public BigInteger[] decomposeScalar(BigInteger bigInteger) {
        return EndoUtil.decomposeScalar(this.parameters.getSplitParams(), bigInteger);
    }

    @Override
    public ECPointMap getPointMap() {
        return this.pointMap;
    }

    @Override
    public boolean hasEfficientPointMap() {
        return true;
    }
}

