/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.operator.bc;

import java.io.IOException;
import thirdparty.bouncycastle.asn1.x509.AlgorithmIdentifier;
import thirdparty.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import thirdparty.bouncycastle.crypto.ExtendedDigest;
import thirdparty.bouncycastle.crypto.Signer;
import thirdparty.bouncycastle.crypto.params.AsymmetricKeyParameter;
import thirdparty.bouncycastle.crypto.signers.DSADigestSigner;
import thirdparty.bouncycastle.crypto.signers.ECDSASigner;
import thirdparty.bouncycastle.crypto.util.PublicKeyFactory;
import thirdparty.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import thirdparty.bouncycastle.operator.OperatorCreationException;
import thirdparty.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;

public class BcECContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcECContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    @Override
    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new DSADigestSigner(new ECDSASigner(), extendedDigest);
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

