/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.operator.bc;

import java.io.IOException;
import thirdparty.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import thirdparty.bouncycastle.asn1.x509.AlgorithmIdentifier;
import thirdparty.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import thirdparty.bouncycastle.crypto.Signer;
import thirdparty.bouncycastle.crypto.params.AsymmetricKeyParameter;
import thirdparty.bouncycastle.crypto.signers.Ed25519Signer;
import thirdparty.bouncycastle.crypto.signers.Ed448Signer;
import thirdparty.bouncycastle.crypto.util.PublicKeyFactory;
import thirdparty.bouncycastle.operator.OperatorCreationException;
import thirdparty.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;

public class BcEdDSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    public static final byte[] DEFAULT_CONTEXT = new byte[0];

    @Override
    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        if (algorithmIdentifier.getAlgorithm().equals(EdECObjectIdentifiers.id_Ed448)) {
            return new Ed448Signer(DEFAULT_CONTEXT);
        }
        return new Ed25519Signer();
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

