/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.operator.jcajce;

import java.io.InputStream;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import thirdparty.bouncycastle.asn1.ASN1Encodable;
import thirdparty.bouncycastle.asn1.ASN1ObjectIdentifier;
import thirdparty.bouncycastle.asn1.ASN1OctetString;
import thirdparty.bouncycastle.asn1.cryptopro.GOST28147Parameters;
import thirdparty.bouncycastle.asn1.x509.AlgorithmIdentifier;
import thirdparty.bouncycastle.jcajce.io.CipherInputStream;
import thirdparty.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import thirdparty.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import thirdparty.bouncycastle.jcajce.util.JcaJceHelper;
import thirdparty.bouncycastle.jcajce.util.NamedJcaJceHelper;
import thirdparty.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import thirdparty.bouncycastle.operator.InputDecryptor;
import thirdparty.bouncycastle.operator.InputDecryptorProvider;
import thirdparty.bouncycastle.operator.OperatorCreationException;
import thirdparty.bouncycastle.util.Arrays;

public class JceInputDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JceInputDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JceInputDecryptorProviderBuilder setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    public InputDecryptorProvider build(byte[] byArray) {
        final byte[] byArray2 = Arrays.clone(byArray);
        return new InputDecryptorProvider(){
            private Cipher cipher;
            private AlgorithmIdentifier encryptionAlg;

            @Override
            public InputDecryptor get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                this.encryptionAlg = algorithmIdentifier;
                ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
                try {
                    this.cipher = JceInputDecryptorProviderBuilder.this.helper.createCipher(aSN1ObjectIdentifier.getId());
                    SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, aSN1ObjectIdentifier.getId());
                    ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
                    if (aSN1Encodable instanceof ASN1OctetString) {
                        this.cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(ASN1OctetString.getInstance(aSN1Encodable).getOctets()));
                    } else {
                        GOST28147Parameters gOST28147Parameters = GOST28147Parameters.getInstance(aSN1Encodable);
                        this.cipher.init(2, (Key)secretKeySpec, new GOST28147ParameterSpec(gOST28147Parameters.getEncryptionParamSet(), gOST28147Parameters.getIV()));
                    }
                }
                catch (Exception exception) {
                    throw new OperatorCreationException("unable to create InputDecryptor: " + exception.getMessage(), exception);
                }
                return new InputDecryptor(){

                    @Override
                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return encryptionAlg;
                    }

                    @Override
                    public InputStream getInputStream(InputStream inputStream) {
                        return new CipherInputStream(inputStream, cipher);
                    }
                };
            }
        };
    }
}

