/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.pkcs;

import java.io.OutputStream;
import thirdparty.bouncycastle.asn1.pkcs.MacData;
import thirdparty.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import thirdparty.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import thirdparty.bouncycastle.asn1.x509.AlgorithmIdentifier;
import thirdparty.bouncycastle.asn1.x509.DigestInfo;
import thirdparty.bouncycastle.operator.MacCalculator;
import thirdparty.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import thirdparty.bouncycastle.pkcs.PKCSException;
import thirdparty.bouncycastle.util.Strings;

class MacDataGenerator {
    private PKCS12MacCalculatorBuilder builder;

    MacDataGenerator(PKCS12MacCalculatorBuilder pKCS12MacCalculatorBuilder) {
        this.builder = pKCS12MacCalculatorBuilder;
    }

    public MacData build(char[] cArray, byte[] byArray) throws PKCSException {
        int n;
        byte[] byArray2;
        Object object;
        MacCalculator macCalculator;
        try {
            macCalculator = this.builder.build(cArray);
            object = macCalculator.getOutputStream();
            ((OutputStream)object).write(byArray);
            ((OutputStream)object).close();
        }
        catch (Exception exception) {
            throw new PKCSException("unable to process data: " + exception.getMessage(), exception);
        }
        object = macCalculator.getAlgorithmIdentifier();
        DigestInfo digestInfo = new DigestInfo(this.builder.getDigestAlgorithmIdentifier(), macCalculator.getMac());
        if (PKCSObjectIdentifiers.id_PBMAC1.equals(digestInfo.getAlgorithmId().getAlgorithm())) {
            byArray2 = Strings.toUTF8ByteArray("NOT USED".toCharArray());
            n = 1;
        } else {
            PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(((AlgorithmIdentifier)object).getParameters());
            byArray2 = pKCS12PBEParams.getIV();
            n = pKCS12PBEParams.getIterations().intValue();
        }
        return new MacData(digestInfo, byArray2, n);
    }
}

