/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.pqc.crypto.hqc;

import java.security.SecureRandom;
import thirdparty.bouncycastle.crypto.EncapsulatedSecretGenerator;
import thirdparty.bouncycastle.crypto.SecretWithEncapsulation;
import thirdparty.bouncycastle.crypto.params.AsymmetricKeyParameter;
import thirdparty.bouncycastle.pqc.crypto.hqc.HQCEngine;
import thirdparty.bouncycastle.pqc.crypto.hqc.HQCPublicKeyParameters;
import thirdparty.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import thirdparty.bouncycastle.util.Arrays;

public class HQCKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public HQCKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        HQCPublicKeyParameters hQCPublicKeyParameters = (HQCPublicKeyParameters)asymmetricKeyParameter;
        HQCEngine hQCEngine = hQCPublicKeyParameters.getParameters().getEngine();
        byte[] byArray = new byte[hQCPublicKeyParameters.getParameters().getSHA512_BYTES()];
        byte[] byArray2 = new byte[hQCPublicKeyParameters.getParameters().getN_BYTES()];
        byte[] byArray3 = new byte[hQCPublicKeyParameters.getParameters().getN1N2_BYTES()];
        byte[] byArray4 = new byte[hQCPublicKeyParameters.getParameters().getSALT_SIZE_BYTES()];
        byte[] byArray5 = hQCPublicKeyParameters.getPublicKey();
        byte[] byArray6 = new byte[48];
        this.sr.nextBytes(byArray6);
        hQCEngine.encaps(byArray2, byArray3, byArray, byArray5, byArray6, byArray4);
        byte[] byArray7 = Arrays.concatenate(byArray2, byArray3, byArray4);
        return new SecretWithEncapsulationImpl(Arrays.copyOfRange(byArray, 0, hQCPublicKeyParameters.getParameters().getK()), byArray7);
    }
}

