/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.pqc.crypto.lms;

import java.security.SecureRandom;
import thirdparty.bouncycastle.crypto.AsymmetricCipherKeyPair;
import thirdparty.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import thirdparty.bouncycastle.crypto.KeyGenerationParameters;
import thirdparty.bouncycastle.pqc.crypto.lms.LMS;
import thirdparty.bouncycastle.pqc.crypto.lms.LMSKeyGenerationParameters;
import thirdparty.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import thirdparty.bouncycastle.pqc.crypto.lms.LMSigParameters;

public class LMSKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    LMSKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (LMSKeyGenerationParameters)keyGenerationParameters;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        SecureRandom secureRandom = this.param.getRandom();
        byte[] byArray = new byte[16];
        secureRandom.nextBytes(byArray);
        LMSigParameters lMSigParameters = this.param.getParameters().getLMSigParam();
        byte[] byArray2 = new byte[lMSigParameters.getM()];
        secureRandom.nextBytes(byArray2);
        LMSPrivateKeyParameters lMSPrivateKeyParameters = LMS.generateKeys(lMSigParameters, this.param.getParameters().getLMOTSParam(), 0, byArray, byArray2);
        return new AsymmetricCipherKeyPair(lMSPrivateKeyParameters.getPublicKey(), lMSPrivateKeyParameters);
    }
}

