/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.pqc.crypto.ntru;

import java.security.SecureRandom;
import thirdparty.bouncycastle.crypto.AsymmetricCipherKeyPair;
import thirdparty.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import thirdparty.bouncycastle.crypto.KeyGenerationParameters;
import thirdparty.bouncycastle.pqc.crypto.ntru.NTRUKeyGenerationParameters;
import thirdparty.bouncycastle.pqc.crypto.ntru.NTRUOWCPA;
import thirdparty.bouncycastle.pqc.crypto.ntru.NTRUParameters;
import thirdparty.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import thirdparty.bouncycastle.pqc.crypto.ntru.NTRUPublicKeyParameters;
import thirdparty.bouncycastle.pqc.crypto.ntru.OWCPAKeyPair;
import thirdparty.bouncycastle.pqc.math.ntru.parameters.NTRUParameterSet;
import thirdparty.bouncycastle.util.Arrays;

public class NTRUKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private NTRUKeyGenerationParameters params;
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.params = (NTRUKeyGenerationParameters)keyGenerationParameters;
        this.random = keyGenerationParameters.getRandom();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        NTRUParameters nTRUParameters = this.params.getParameters();
        NTRUParameterSet nTRUParameterSet = nTRUParameters.getParameterSet();
        byte[] byArray = new byte[nTRUParameterSet.sampleFgBytes()];
        this.random.nextBytes(byArray);
        NTRUOWCPA nTRUOWCPA = new NTRUOWCPA(nTRUParameterSet);
        OWCPAKeyPair oWCPAKeyPair = nTRUOWCPA.keypair(byArray);
        byte[] byArray2 = oWCPAKeyPair.publicKey;
        byte[] byArray3 = new byte[nTRUParameterSet.prfKeyBytes()];
        this.random.nextBytes(byArray3);
        byte[] byArray4 = Arrays.concatenate(oWCPAKeyPair.privateKey, byArray3);
        return new AsymmetricCipherKeyPair(new NTRUPublicKeyParameters(nTRUParameters, byArray2), new NTRUPrivateKeyParameters(nTRUParameters, byArray4));
    }
}

