/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.pqc.crypto.xwing;

import thirdparty.bouncycastle.crypto.params.AsymmetricKeyParameter;
import thirdparty.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import thirdparty.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import thirdparty.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import thirdparty.bouncycastle.pqc.crypto.xwing.XWingKeyParameters;
import thirdparty.bouncycastle.util.Arrays;

public class XWingPrivateKeyParameters
extends XWingKeyParameters {
    private final MLKEMPrivateKeyParameters kybPriv;
    private final X25519PrivateKeyParameters xdhPriv;

    XWingPrivateKeyParameters(AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2) {
        super(true);
        this.kybPriv = (MLKEMPrivateKeyParameters)asymmetricKeyParameter;
        this.xdhPriv = (X25519PrivateKeyParameters)asymmetricKeyParameter2;
    }

    public XWingPrivateKeyParameters(byte[] byArray) {
        super(false);
        this.kybPriv = new MLKEMPrivateKeyParameters(MLKEMParameters.ml_kem_768, Arrays.copyOfRange(byArray, 0, byArray.length - 32));
        this.xdhPriv = new X25519PrivateKeyParameters(byArray, byArray.length - 32);
    }

    MLKEMPrivateKeyParameters getKyberPrivateKey() {
        return this.kybPriv;
    }

    X25519PrivateKeyParameters getXDHPrivateKey() {
        return this.xdhPriv;
    }

    public byte[] getEncoded() {
        return Arrays.concatenate(this.kybPriv.getEncoded(), this.xdhPriv.getEncoded());
    }
}

