/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.pqc.crypto.xwing;

import thirdparty.bouncycastle.crypto.params.AsymmetricKeyParameter;
import thirdparty.bouncycastle.crypto.params.X25519PublicKeyParameters;
import thirdparty.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import thirdparty.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;
import thirdparty.bouncycastle.pqc.crypto.xwing.XWingKeyParameters;
import thirdparty.bouncycastle.util.Arrays;

public class XWingPublicKeyParameters
extends XWingKeyParameters {
    private final MLKEMPublicKeyParameters kybPub;
    private final X25519PublicKeyParameters xdhPub;

    XWingPublicKeyParameters(AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2) {
        super(false);
        this.kybPub = (MLKEMPublicKeyParameters)asymmetricKeyParameter;
        this.xdhPub = (X25519PublicKeyParameters)asymmetricKeyParameter2;
    }

    public XWingPublicKeyParameters(byte[] byArray) {
        super(false);
        this.kybPub = new MLKEMPublicKeyParameters(MLKEMParameters.ml_kem_768, Arrays.copyOfRange(byArray, 0, byArray.length - 32));
        this.xdhPub = new X25519PublicKeyParameters(byArray, byArray.length - 32);
    }

    MLKEMPublicKeyParameters getKyberPublicKey() {
        return this.kybPub;
    }

    X25519PublicKeyParameters getXDHPublicKey() {
        return this.xdhPub;
    }

    public byte[] getEncoded() {
        return Arrays.concatenate(this.kybPub.getEncoded(), this.xdhPub.getEncoded());
    }
}

