/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skiko.Actuals_jvmKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B)\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001b\u001a\u00020\u001cJ\f\u0010\u001d\u001a\u00020\u0011*\u00020\u0003H\u0002J\f\u0010\u001e\u001a\u00020\u0003*\u00020\u0011H\u0002J\f\u0010\u001f\u001a\u00020\u0011*\u00020\u0003H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0015\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000fR\u000e\u0010\u0017\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/skiko/FPSCounter;", "", "periodSeconds", "", "showLongFrames", "", "getLongFrameMillis", "Lkotlin/Function0;", "(DZLkotlin/jvm/functions/Function0;)V", "_average", "", "_max", "_min", "average", "getAverage", "()I", "lastLogTime", "", "lastTime", "max", "getMax", "min", "getMin", "nanosPerMillis", "nanosPerSecond", "times", "", "tick", "", "millisToNanos", "nanosToMillis", "secondsToNanos", "skiko"})
public final class FPSCounter {
    private final double periodSeconds;
    private final boolean showLongFrames;
    @NotNull
    private final Function0<Double> getLongFrameMillis;
    @NotNull
    private final List<Long> times;
    private long lastLogTime;
    private long lastTime;
    private int _average;
    private int _min;
    private int _max;
    private final double nanosPerMillis;
    private final double nanosPerSecond;

    public FPSCounter(double periodSeconds, boolean showLongFrames, @NotNull Function0<Double> getLongFrameMillis) {
        Intrinsics.checkNotNullParameter(getLongFrameMillis, (String)"getLongFrameMillis");
        this.periodSeconds = periodSeconds;
        this.showLongFrames = showLongFrames;
        this.getLongFrameMillis = getLongFrameMillis;
        this.times = new ArrayList();
        this.lastLogTime = Actuals_jvmKt.currentNanoTime();
        this.lastTime = Actuals_jvmKt.currentNanoTime();
        this.nanosPerMillis = 1000000.0;
        this.nanosPerSecond = 1.0E9;
    }

    public /* synthetic */ FPSCounter(double d, boolean bl, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 2.0;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            function0 = 1.INSTANCE;
        }
        this(d, bl, (Function0<Double>)function0);
    }

    public final void tick() {
        long time = Actuals_jvmKt.currentNanoTime();
        long timestamp = (long)this.nanosToMillis(time);
        long frameTime = time - this.lastTime;
        this.lastTime = time;
        this.times.add(frameTime);
        if (this.showLongFrames && frameTime > this.millisToNanos(((Number)this.getLongFrameMillis.invoke()).doubleValue())) {
            System.out.println((Object)(timestamp + " Long frame " + this.nanosToMillis(frameTime) + " ms"));
        }
        if (time - this.lastLogTime > this.secondsToNanos(this.periodSeconds) && !((Collection)this.times).isEmpty()) {
            this._average = MathKt.roundToInt((double)(this.nanosPerSecond / CollectionsKt.averageOfLong((Iterable)this.times)));
            Comparable comparable = CollectionsKt.maxOrNull((Iterable)this.times);
            Intrinsics.checkNotNull((Object)comparable);
            this._min = MathKt.roundToInt((double)(this.nanosPerSecond / ((Number)((Object)comparable)).doubleValue()));
            Comparable comparable2 = CollectionsKt.minOrNull((Iterable)this.times);
            Intrinsics.checkNotNull((Object)comparable2);
            this._max = MathKt.roundToInt((double)(this.nanosPerSecond / ((Number)((Object)comparable2)).doubleValue()));
            this.times.clear();
            this.lastLogTime = time;
        }
    }

    public final int getAverage() {
        return this._average;
    }

    public final int getMin() {
        return this._min;
    }

    public final int getMax() {
        return this._max;
    }

    private final double nanosToMillis(long $this$nanosToMillis) {
        return (double)$this$nanosToMillis / this.nanosPerMillis;
    }

    private final long millisToNanos(double $this$millisToNanos) {
        return (long)($this$millisToNanos * this.nanosPerMillis);
    }

    private final long secondsToNanos(double $this$secondsToNanos) {
        return (long)($this$secondsToNanos * this.nanosPerSecond);
    }

    public FPSCounter() {
        this(0.0, false, null, 7, null);
    }
}

