/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.awt.Desktop;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.net.URI;
import javax.swing.UIManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.Actuals_awtKt;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.RenderFactory;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.redrawer.Direct3DRedrawer;
import org.jetbrains.skiko.redrawer.LinuxOpenGLRedrawer;
import org.jetbrains.skiko.redrawer.LinuxSoftwareRedrawer;
import org.jetbrains.skiko.redrawer.MetalRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;
import org.jetbrains.skiko.redrawer.SoftwareRedrawer;
import org.jetbrains.skiko.redrawer.WindowsOpenGLRedrawer;
import org.jetbrains.skiko.redrawer.WindowsSoftwareRedrawer;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0000\u001a\b\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0006\u0010\u000f\u001a\u00020\t\"\u001d\u0010\u0000\u001a\u0004\u0018\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0010"}, d2={"systemClipboard", "Ljava/awt/datatransfer/Clipboard;", "getSystemClipboard", "()Ljava/awt/datatransfer/Clipboard;", "systemClipboard$delegate", "Lkotlin/Lazy;", "ClipboardManager_getText", "", "ClipboardManager_setText", "", "text", "URIHandler_openUri", "uri", "makeDefaultRenderFactory", "Lorg/jetbrains/skiko/RenderFactory;", "setSystemLookAndFeel", "skiko"})
public final class Actuals_awtKt {
    @NotNull
    private static final Lazy systemClipboard$delegate = LazyKt.lazy((Function0)systemClipboard.2.INSTANCE);

    public static final void setSystemLookAndFeel() {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    @NotNull
    public static final RenderFactory makeDefaultRenderFactory() {
        return new RenderFactory(){

            @NotNull
            public Redrawer createRedrawer(@NotNull SkiaLayer layer, @NotNull GraphicsApi renderApi, @NotNull SkiaLayerProperties properties) {
                Redrawer redrawer;
                Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
                Intrinsics.checkNotNullParameter((Object)((Object)renderApi), (String)"renderApi");
                Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
                block0 : switch (makeDefaultRenderFactory.WhenMappings.$EnumSwitchMapping$0[OsArch_jvmKt.getHostOs().ordinal()]) {
                    case 1: {
                        switch (makeDefaultRenderFactory.WhenMappings.$EnumSwitchMapping$1[renderApi.ordinal()]) {
                            case 1: 
                            case 2: {
                                redrawer = new SoftwareRedrawer(layer, properties);
                                break block0;
                            }
                        }
                        redrawer = new MetalRedrawer(layer, properties);
                        break;
                    }
                    case 2: {
                        switch (makeDefaultRenderFactory.WhenMappings.$EnumSwitchMapping$1[renderApi.ordinal()]) {
                            case 1: {
                                redrawer = new SoftwareRedrawer(layer, properties);
                                break block0;
                            }
                            case 2: {
                                redrawer = new WindowsSoftwareRedrawer(layer, properties);
                                break block0;
                            }
                            case 3: {
                                redrawer = new WindowsOpenGLRedrawer(layer, properties);
                                break block0;
                            }
                        }
                        redrawer = new Direct3DRedrawer(layer, properties);
                        break;
                    }
                    case 3: {
                        switch (makeDefaultRenderFactory.WhenMappings.$EnumSwitchMapping$1[renderApi.ordinal()]) {
                            case 1: {
                                redrawer = new SoftwareRedrawer(layer, properties);
                                break block0;
                            }
                            case 2: {
                                redrawer = new LinuxSoftwareRedrawer(layer, properties);
                                break block0;
                            }
                        }
                        redrawer = new LinuxOpenGLRedrawer(layer, properties);
                        break;
                    }
                    case 4: {
                        throw new NotImplementedError(null, 1, null);
                    }
                    case 5: 
                    case 6: {
                        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"Commonize me"));
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return redrawer;
            }
        };
    }

    public static final void URIHandler_openUri(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Desktop.getDesktop().browse(new URI(uri));
    }

    private static final Clipboard getSystemClipboard() {
        Lazy lazy = systemClipboard$delegate;
        return (Clipboard)lazy.getValue();
    }

    public static final void ClipboardManager_setText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Clipboard clipboard = Actuals_awtKt.getSystemClipboard();
        if (clipboard != null) {
            clipboard.setContents(new StringSelection(text), null);
        }
    }

    @Nullable
    public static final String ClipboardManager_getText() {
        String string;
        try {
            Clipboard clipboard = Actuals_awtKt.getSystemClipboard();
            string = (String)(clipboard == null ? null : clipboard.getData(DataFlavor.stringFlavor));
        }
        catch (UnsupportedFlavorException _) {
            string = null;
        }
        return string;
    }
}

