/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.GpuPriority;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001c\u001a\u00020\u0015H\u0002J\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u001e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b J\u0017\u0010!\u001a\u00020\u00152\b\u0010\"\u001a\u0004\u0018\u00010#H\u0000\u00a2\u0006\u0002\b$R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0006R\u0011\u0010\u001a\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0006\u00a8\u0006%"}, d2={"Lorg/jetbrains/skiko/SkikoProperties;", "", "()V", "fpsEnabled", "", "getFpsEnabled", "()Z", "fpsLongFramesMillis", "", "getFpsLongFramesMillis", "()Ljava/lang/Double;", "fpsLongFramesShow", "getFpsLongFramesShow", "fpsPeriodSeconds", "getFpsPeriodSeconds", "()D", "gpuPriority", "Lorg/jetbrains/skiko/GpuPriority;", "getGpuPriority", "()Lorg/jetbrains/skiko/GpuPriority;", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "vsyncEnabled", "getVsyncEnabled", "vsyncFramelimitFallbackEnabled", "getVsyncFramelimitFallbackEnabled", "bestRenderApiForCurrentOS", "fallbackRenderApiQueue", "", "initialApi", "fallbackRenderApiQueue$skiko", "parseRenderApi", "text", "", "parseRenderApi$skiko", "skiko"})
public final class SkikoProperties {
    @NotNull
    public static final SkikoProperties INSTANCE = new SkikoProperties();

    private SkikoProperties() {
    }

    public final boolean getVsyncEnabled() {
        boolean bl;
        String string = System.getProperty("skiko.vsync.enabled");
        return string == null ? true : (bl = Boolean.parseBoolean(string));
    }

    public final boolean getVsyncFramelimitFallbackEnabled() {
        boolean bl;
        String string = System.getProperty("skiko.vsync.framelimit.fallback.enabled");
        return string == null ? true : (bl = Boolean.parseBoolean(string));
    }

    public final boolean getFpsEnabled() {
        boolean bl;
        String string = System.getProperty("skiko.fps.enabled");
        return string == null ? false : (bl = Boolean.parseBoolean(string));
    }

    public final double getFpsPeriodSeconds() {
        double d;
        String string = System.getProperty("skiko.fps.periodSeconds");
        return string == null ? 2.0 : (d = Double.parseDouble(string));
    }

    public final boolean getFpsLongFramesShow() {
        boolean bl;
        String string = System.getProperty("skiko.fps.longFrames.show");
        return string == null ? false : (bl = Boolean.parseBoolean(string));
    }

    @Nullable
    public final Double getFpsLongFramesMillis() {
        String string = System.getProperty("skiko.fps.longFrames.millis");
        return string == null ? null : Double.valueOf(Double.parseDouble(string));
    }

    @NotNull
    public final GraphicsApi getRenderApi() {
        String environment = System.getenv("SKIKO_RENDER_API");
        String property = System.getProperty("skiko.renderApi");
        return environment != null ? this.parseRenderApi$skiko(environment) : this.parseRenderApi$skiko(property);
    }

    @NotNull
    public final GpuPriority getGpuPriority() {
        GpuPriority gpuPriority;
        String value;
        String string = System.getProperty("skiko.gpu.priority");
        if (string == null) {
            String string2 = System.getProperty("skiko.metal.gpu.priority");
            string = string2 == null ? System.getProperty("skiko.directx.gpu.priority") : string2;
        }
        String string3 = value = string;
        if (string3 == null) {
            gpuPriority = null;
        } else {
            String string4 = string3;
            GpuPriority.Companion companion = GpuPriority.Companion;
            String p0 = string4;
            boolean bl = false;
            gpuPriority = companion.parseOrNull(p0);
        }
        GpuPriority gpuPriority2 = gpuPriority;
        if (gpuPriority == null) {
            gpuPriority2 = GpuPriority.Auto;
        }
        return gpuPriority2;
    }

    @NotNull
    public final GraphicsApi parseRenderApi$skiko(@Nullable String text) {
        block25: {
            String string = text;
            if (string == null) break block25;
            int n = -1;
            switch (string.hashCode()) {
                case -1019861004: {
                    if (string.equals("SOFTWARE_FAST")) {
                        n = 1;
                    }
                    break;
                }
                case -907020006: {
                    if (string.equals("SOFTWARE_COMPAT")) {
                        n = 2;
                    }
                    break;
                }
                case -1957249873: {
                    if (string.equals("OPENGL")) {
                        n = 3;
                    }
                    break;
                }
                case 1028669466: {
                    if (string.equals("DIRECT3D")) {
                        n = 4;
                    }
                    break;
                }
                case 73249511: {
                    if (string.equals("METAL")) {
                        n = 5;
                    }
                    break;
                }
                case 2101957031: {
                    if (string.equals("SOFTWARE")) {
                        n = 1;
                    }
                    break;
                }
                case 1644349757: {
                    if (string.equals("DIRECT_SOFTWARE")) {
                        n = 1;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    return GraphicsApi.SOFTWARE_COMPAT;
                }
                case 1: {
                    return GraphicsApi.SOFTWARE_FAST;
                }
                case 3: {
                    return GraphicsApi.OPENGL;
                }
                case 4: {
                    if (OsArch_jvmKt.getHostOs() != OS.Windows) {
                        throw new Exception((Object)((Object)OsArch_jvmKt.getHostOs()) + " does not support DirectX rendering API.");
                    }
                    return GraphicsApi.DIRECT3D;
                }
                case 5: {
                    if (OsArch_jvmKt.getHostOs() != OS.MacOS) {
                        throw new Exception((Object)((Object)OsArch_jvmKt.getHostOs()) + " does not support Metal rendering API.");
                    }
                    return GraphicsApi.METAL;
                }
            }
        }
        return this.bestRenderApiForCurrentOS();
    }

    private final GraphicsApi bestRenderApiForCurrentOS() {
        switch (WhenMappings.$EnumSwitchMapping$0[OsArch_jvmKt.getHostOs().ordinal()]) {
            case 1: {
                return GraphicsApi.METAL;
            }
            case 2: {
                return GraphicsApi.OPENGL;
            }
            case 3: {
                return GraphicsApi.DIRECT3D;
            }
            case 4: {
                return GraphicsApi.OPENGL;
            }
            case 5: 
            case 6: {
                throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"commonize me"));
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public final List<GraphicsApi> fallbackRenderApiQueue$skiko(@NotNull GraphicsApi initialApi) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)((Object)initialApi), (String)"initialApi");
        switch (WhenMappings.$EnumSwitchMapping$0[OsArch_jvmKt.getHostOs().ordinal()]) {
            case 2: {
                GraphicsApi[] graphicsApiArray = new GraphicsApi[]{GraphicsApi.OPENGL, GraphicsApi.SOFTWARE_FAST, GraphicsApi.SOFTWARE_COMPAT};
                list2 = CollectionsKt.listOf((Object[])graphicsApiArray);
                break;
            }
            case 1: {
                GraphicsApi[] graphicsApiArray = new GraphicsApi[]{GraphicsApi.METAL, GraphicsApi.SOFTWARE_COMPAT};
                list2 = CollectionsKt.listOf((Object[])graphicsApiArray);
                break;
            }
            case 3: {
                GraphicsApi[] graphicsApiArray = new GraphicsApi[]{GraphicsApi.DIRECT3D, GraphicsApi.OPENGL, GraphicsApi.SOFTWARE_FAST, GraphicsApi.SOFTWARE_COMPAT};
                list2 = CollectionsKt.listOf((Object[])graphicsApiArray);
                break;
            }
            case 4: {
                return CollectionsKt.listOf((Object)((Object)GraphicsApi.OPENGL));
            }
            case 5: 
            case 6: {
                throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"commonize me"));
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List fallbackApis = list2;
        int indexOfInitialApi = fallbackApis.indexOf((Object)initialApi);
        if (!(indexOfInitialApi >= 0)) {
            boolean bl = false;
            String string = (Object)((Object)OsArch_jvmKt.getHostOs()) + " does not support " + (Object)((Object)initialApi) + " rendering API.";
            throw new IllegalArgumentException(string.toString());
        }
        fallbackApis = CollectionsKt.drop((Iterable)fallbackApis, (int)(indexOfInitialApi + 1));
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((Object)initialApi)), (Iterable)fallbackApis);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            nArray[OS.MacOS.ordinal()] = 1;
            nArray[OS.Linux.ordinal()] = 2;
            nArray[OS.Windows.ordinal()] = 3;
            nArray[OS.Android.ordinal()] = 4;
            nArray[OS.JS.ordinal()] = 5;
            nArray[OS.Ios.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

