/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.DirectContextKt;
import org.jetbrains.skia.GLBackendState;
import org.jetbrains.skia.impl.Library;
import org.jetbrains.skia.impl.Native_jvmKt;
import org.jetbrains.skia.impl.RefCnt;
import org.jetbrains.skia.impl.Stats;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0013\b\u0000\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0000J\u0006\u0010\t\u001a\u00020\u0000J\u001f\u0010\n\u001a\u00020\u00002\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/skia/DirectContext;", "Lorg/jetbrains/skia/impl/RefCnt;", "ptr", "", "Lorg/jetbrains/skia/impl/NativePointer;", "(J)V", "abandon", "", "flush", "resetAll", "resetGL", "states", "", "Lorg/jetbrains/skia/GLBackendState;", "([Lorg/jetbrains/skia/GLBackendState;)Lorg/jetbrains/skia/DirectContext;", "resetGLAll", "submit", "syncCpu", "", "Companion", "skiko"})
public final class DirectContext
extends RefCnt {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public DirectContext(long ptr) {
        super(ptr);
    }

    @NotNull
    public final DirectContext flush() {
        Stats.INSTANCE.onNativeCall();
        DirectContextKt.access$DirectContext_nFlush(this.get_ptr());
        return this;
    }

    @NotNull
    public final DirectContext resetAll() {
        Stats.INSTANCE.onNativeCall();
        DirectContextKt.access$_nReset(this.get_ptr(), -1);
        return this;
    }

    @NotNull
    public final DirectContext resetGLAll() {
        Stats.INSTANCE.onNativeCall();
        DirectContextKt.access$_nReset(this.get_ptr(), 65535);
        return this;
    }

    @NotNull
    public final DirectContext resetGL(GLBackendState ... states) {
        Intrinsics.checkNotNullParameter((Object)states, (String)"states");
        Stats.INSTANCE.onNativeCall();
        int flags = 0;
        GLBackendState[] gLBackendStateArray = states;
        int n = 0;
        int n2 = gLBackendStateArray.length;
        while (n < n2) {
            GLBackendState state2 = gLBackendStateArray[n];
            ++n;
            flags |= state2.get_bit$skiko();
        }
        DirectContextKt.access$_nReset(this.get_ptr(), flags);
        return this;
    }

    public final void submit(boolean syncCpu) {
        Stats.INSTANCE.onNativeCall();
        DirectContextKt.access$_nSubmit(this.get_ptr(), syncCpu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abandon() {
        try {
            Stats.INSTANCE.onNativeCall();
            DirectContextKt.access$_nAbandon(this.get_ptr());
        }
        finally {
            Native_jvmKt.reachabilityBarrier(this);
        }
    }

    static {
        Library.Companion.staticLoad();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u00060\u0006j\u0002`\u00072\n\u0010\t\u001a\u00060\u0006j\u0002`\u0007J\u0006\u0010\n\u001a\u00020\u0004J\u001e\u0010\u000b\u001a\u00020\u00042\n\u0010\b\u001a\u00060\u0006j\u0002`\u00072\n\u0010\t\u001a\u00060\u0006j\u0002`\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/skia/DirectContext$Companion;", "", "()V", "makeDirect3D", "Lorg/jetbrains/skia/DirectContext;", "adapterPtr", "", "Lorg/jetbrains/skia/impl/NativePointer;", "devicePtr", "queuePtr", "makeGL", "makeMetal", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DirectContext makeGL() {
            Stats.INSTANCE.onNativeCall();
            return new DirectContext(DirectContextKt.access$_nMakeGL());
        }

        @NotNull
        public final DirectContext makeMetal(long devicePtr, long queuePtr) {
            Stats.INSTANCE.onNativeCall();
            return new DirectContext(DirectContextKt.access$_nMakeMetal(devicePtr, queuePtr));
        }

        @NotNull
        public final DirectContext makeDirect3D(long adapterPtr, long devicePtr, long queuePtr) {
            Stats.INSTANCE.onNativeCall();
            return new DirectContext(DirectContextKt.access$_nMakeDirect3D(adapterPtr, devicePtr, queuePtr));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

