/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.IPoint;
import org.jetbrains.skia.Rect;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0013\u001a\u00020\u0000J\u0016\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\r\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020!H\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\t\u00a8\u0006#"}, d2={"Lorg/jetbrains/skia/IRect;", "", "left", "", "top", "right", "bottom", "(IIII)V", "getBottom", "()I", "height", "getHeight", "getLeft", "getRight", "getTop", "width", "getWidth", "equals", "", "other", "hashCode", "intersect", "offset", "dx", "dy", "vec", "Lorg/jetbrains/skia/IPoint;", "serializeToIntArray", "", "serializeToIntArray$skiko", "toRect", "Lorg/jetbrains/skia/Rect;", "toString", "", "Companion", "skiko"})
public final class IRect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int left;
    private final int top;
    private final int right;
    private final int bottom;

    public IRect(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public final int getLeft() {
        return this.left;
    }

    public final int getTop() {
        return this.top;
    }

    public final int getRight() {
        return this.right;
    }

    public final int getBottom() {
        return this.bottom;
    }

    public final int getWidth() {
        return this.right - this.left;
    }

    public final int getHeight() {
        return this.bottom - this.top;
    }

    @Nullable
    public final IRect intersect(@NotNull IRect other) {
        IRect iRect;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.right <= other.left || other.right <= this.left || this.bottom <= other.top || other.bottom <= this.top) {
            iRect = null;
        } else {
            int n = this.left;
            int n2 = other.left;
            boolean bl = false;
            int n3 = Math.max(n, n2);
            n = this.top;
            n2 = other.top;
            bl = false;
            int n4 = Math.max(n, n2);
            n = this.right;
            n2 = other.right;
            bl = false;
            int n5 = Math.min(n, n2);
            n = this.bottom;
            n2 = other.bottom;
            bl = false;
            IRect iRect2 = new IRect(n3, n4, n5, Math.min(n, n2));
            iRect = iRect2;
        }
        return iRect;
    }

    @NotNull
    public final IRect offset(int dx, int dy) {
        return new IRect(this.left + dx, this.top + dy, this.right + dx, this.bottom + dy);
    }

    @NotNull
    public final IRect offset(@NotNull IPoint vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        return this.offset(vec.getX(), vec.getY());
    }

    @NotNull
    public final Rect toRect() {
        return new Rect(this.left, this.top, this.right, this.bottom);
    }

    @NotNull
    public final int[] serializeToIntArray$skiko() {
        int[] nArray = new int[]{this.left, this.top, this.right, this.bottom};
        return nArray;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof IRect)) {
            return false;
        }
        if (this.left != ((IRect)other).left) {
            return false;
        }
        if (this.top != ((IRect)other).top) {
            return false;
        }
        if (this.right != ((IRect)other).right) {
            return false;
        }
        return this.bottom == ((IRect)other).bottom;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.left;
        result = result * PRIME + this.top;
        result = result * PRIME + this.right;
        result = result * PRIME + this.bottom;
        return result;
    }

    @NotNull
    public String toString() {
        return "IRect(_left=" + this.left + ", _top=" + this.top + ", _right=" + this.right + ", _bottom=" + this.bottom + ")";
    }

    @JvmStatic
    @NotNull
    public static final IRect makeLTRB(int l, int t, int r, int b) {
        return Companion.makeLTRB(l, t, r, b);
    }

    @JvmStatic
    @NotNull
    public static final IRect makeXYWH(int l, int t, int w, int h) {
        return Companion.makeXYWH(l, t, w, h);
    }

    @JvmStatic
    @NotNull
    public static final IRect makeWH(int w, int h) {
        return Companion.makeWH(w, h);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0007J(\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/skia/IRect$Companion;", "", "()V", "makeLTRB", "Lorg/jetbrains/skia/IRect;", "l", "", "t", "r", "b", "makeWH", "w", "h", "makeXYWH", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IRect makeLTRB(int l, int t, int r, int b) {
            boolean bl = l <= r;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "IRect::makeLTRB expected l <= r, got " + l + " > " + r;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = t <= b;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "IRect::makeLTRB expected t <= b, got " + t + " > " + b;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return new IRect(l, t, r, b);
        }

        @JvmStatic
        @NotNull
        public final IRect makeXYWH(int l, int t, int w, int h) {
            boolean bl = w >= 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "IRect::makeXYWH expected w >= 0, got: " + w;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = h >= 0;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "IRect::makeXYWH expected h >= 0, got: " + h;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            if (w < 0 || h < 0) {
                throw new IllegalArgumentException();
            }
            return new IRect(l, t, l + w, t + h);
        }

        @JvmStatic
        @NotNull
        public final IRect makeWH(int w, int h) {
            boolean bl = w >= 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "IRect::makeWH expected w >= 0, got: " + w;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = h >= 0;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "IRect::makeWH expected h >= 0, got: " + h;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            if (w < 0 || h < 0) {
                throw new IllegalArgumentException();
            }
            return new IRect(0, 0, w, h);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

