/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.IRect;
import org.jetbrains.skia.Point;
import org.jetbrains.skia.RRect;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.theScope;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0015\u001a\u00020\u0000J\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0003J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003J\r\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b%J\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020)H\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\t\u00a8\u0006+"}, d2={"Lorg/jetbrains/skia/Rect;", "", "left", "", "top", "right", "bottom", "(FFFF)V", "getBottom", "()F", "height", "getHeight", "isEmpty", "", "()Z", "getLeft", "getRight", "getTop", "width", "getWidth", "equals", "other", "hashCode", "", "inflate", "spread", "intersect", "offset", "dx", "dy", "vec", "Lorg/jetbrains/skia/Point;", "scale", "sx", "sy", "serializeToFloatArray", "", "serializeToFloatArray$skiko", "toIRect", "Lorg/jetbrains/skia/IRect;", "toString", "", "Companion", "skiko"})
public class Rect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float left;
    private final float top;
    private final float right;
    private final float bottom;

    public Rect(float left, float top, float right, float bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public final float getLeft() {
        return this.left;
    }

    public final float getTop() {
        return this.top;
    }

    public final float getRight() {
        return this.right;
    }

    public final float getBottom() {
        return this.bottom;
    }

    public final float getWidth() {
        return this.right - this.left;
    }

    public final float getHeight() {
        return this.bottom - this.top;
    }

    @Nullable
    public final Rect intersect(@NotNull Rect other) {
        Rect rect2;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.right <= other.left || other.right <= this.left || this.bottom <= other.top || other.bottom <= this.top) {
            rect2 = null;
        } else {
            float f = this.left;
            float f2 = other.left;
            boolean bl = false;
            float f3 = Math.max(f, f2);
            f = this.top;
            f2 = other.top;
            bl = false;
            float f4 = Math.max(f, f2);
            f = this.right;
            f2 = other.right;
            bl = false;
            float f5 = Math.min(f, f2);
            f = this.bottom;
            f2 = other.bottom;
            bl = false;
            Rect rect3 = new Rect(f3, f4, f5, Math.min(f, f2));
            rect2 = rect3;
        }
        return rect2;
    }

    @NotNull
    public final Rect scale(float scale) {
        return this.scale(scale, scale);
    }

    @NotNull
    public final Rect scale(float sx, float sy) {
        return new Rect(this.left * sx, this.top * sy, this.right * sx, this.bottom * sy);
    }

    @NotNull
    public final Rect offset(float dx, float dy) {
        return new Rect(this.left + dx, this.top + dy, this.right + dx, this.bottom + dy);
    }

    @NotNull
    public final Rect offset(@NotNull Point vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        return this.offset(vec.getX(), vec.getY());
    }

    @NotNull
    public final IRect toIRect() {
        return new IRect((int)this.left, (int)this.top, (int)this.right, (int)this.bottom);
    }

    @NotNull
    public Rect inflate(float spread) {
        Rect rect2;
        if (spread <= 0.0f) {
            float f = this.left - spread;
            float f2 = this.right + spread;
            boolean bl = false;
            float f3 = Math.max(f, f2);
            f = this.top - spread;
            f2 = this.bottom + spread;
            bl = false;
            rect2 = Companion.makeLTRB(this.left - spread, this.top - spread, f3, Math.max(f, f2));
        } else {
            float f = this.left - spread;
            float f4 = this.right + spread;
            boolean bl = false;
            float f5 = Math.max(f, f4);
            f = this.top - spread;
            f4 = this.bottom + spread;
            bl = false;
            rect2 = RRect.Companion.makeLTRB(this.left - spread, this.top - spread, f5, Math.max(f, f4), spread);
        }
        return rect2;
    }

    @NotNull
    public final float[] serializeToFloatArray$skiko() {
        float[] fArray = new float[]{this.left, this.top, this.right, this.bottom};
        return fArray;
    }

    public final boolean isEmpty() {
        return this.right == this.left || this.top == this.bottom;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Rect)) {
            return false;
        }
        if (Float.compare(this.left, ((Rect)other).left) != 0) {
            return false;
        }
        if (Float.compare(this.top, ((Rect)other).top) != 0) {
            return false;
        }
        if (Float.compare(this.right, ((Rect)other).right) != 0) {
            return false;
        }
        return Float.compare(this.bottom, ((Rect)other).bottom) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        float f = this.left;
        boolean bl = false;
        result = result * PRIME + Float.floatToIntBits(f);
        f = this.top;
        bl = false;
        result = result * PRIME + Float.floatToIntBits(f);
        f = this.right;
        bl = false;
        result = result * PRIME + Float.floatToIntBits(f);
        f = this.bottom;
        bl = false;
        result = result * PRIME + Float.floatToIntBits(f);
        return result;
    }

    @NotNull
    public String toString() {
        return "Rect(_left=" + this.left + ", _top=" + this.top + ", _right=" + this.right + ", _bottom=" + this.bottom + ")";
    }

    @JvmStatic
    @NotNull
    public static final Rect makeLTRB(float l, float t, float r, float b) {
        return Companion.makeLTRB(l, t, r, b);
    }

    @JvmStatic
    @NotNull
    public static final Rect makeWH(float w, float h) {
        return Companion.makeWH(w, h);
    }

    @JvmStatic
    @NotNull
    public static final Rect makeWH(@NotNull Point size2) {
        return Companion.makeWH(size2);
    }

    @JvmStatic
    @NotNull
    public static final Rect makeXYWH(float l, float t, float w, float h) {
        return Companion.makeXYWH(l, t, w, h);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072#\u0010\b\u001a\u001f\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\u000b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\b\rH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ2\u0010\u0003\u001a\u00020\u00052#\u0010\b\u001a\u001f\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\u000b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\b\rH\u0000\u00a2\u0006\u0002\b\u000eJ)\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0018\u0010\b\u001a\u0014\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\u000b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b\u0013J(\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0007J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016H\u0007J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001dH\u0007J(\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016H\u0007\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/skia/Rect$Companion;", "", "()V", "fromInteropPointer", "", "Lorg/jetbrains/skia/Rect;", "size", "", "block", "Lkotlin/Function2;", "Lorg/jetbrains/skia/impl/InteropScope;", "Lorg/jetbrains/skia/impl/InteropPointer;", "", "Lkotlin/ExtensionFunctionType;", "fromInteropPointer$skiko", "(ILkotlin/jvm/functions/Function2;)[Lorg/jetbrains/skia/Rect;", "fromInteropPointerNullable", "Lkotlin/Function1;", "", "fromInteropPointerNullable$skiko", "makeLTRB", "l", "", "t", "r", "b", "makeWH", "w", "h", "Lorg/jetbrains/skia/Point;", "makeXYWH", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Rect makeLTRB(float l, float t, float r, float b) {
            boolean bl = l <= r;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Rect::makeLTRB expected l <= r, got " + l + " > " + r;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = t <= b;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Rect::makeLTRB expected t <= b, got " + t + " > " + b;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return new Rect(l, t, r, b);
        }

        @JvmStatic
        @NotNull
        public final Rect makeWH(float w, float h) {
            boolean bl = w >= 0.0f;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Rect::makeWH expected w >= 0, got: " + w;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = h >= 0.0f;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Rect::makeWH expected h >= 0, got: " + h;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return new Rect(0.0f, 0.0f, w, h);
        }

        @JvmStatic
        @NotNull
        public final Rect makeWH(@NotNull Point size2) {
            Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
            return this.makeWH(size2.getX(), size2.getY());
        }

        @JvmStatic
        @NotNull
        public final Rect makeXYWH(float l, float t, float w, float h) {
            boolean bl = w >= 0.0f;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Rect::makeXYWH expected w >= 0, got: " + w;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = h >= 0.0f;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Rect::makeXYWH expected h >= 0, got: " + h;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return new Rect(l, t, l + w, t + h);
        }

        @NotNull
        public final Rect fromInteropPointer$skiko(@NotNull Function2<? super InteropScope, Object, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            float[] result$iv = new float[4];
            boolean $i$f$withResult = false;
            boolean $i$f$interopScope = false;
            InteropScope $this$withResult_u24lambda_u2d2$iv = theScope.INSTANCE;
            boolean bl = false;
            Object handle$iv = $this$withResult_u24lambda_u2d2$iv.toInterop(result$iv);
            block.invoke((Object)$this$withResult_u24lambda_u2d2$iv, handle$iv);
            $this$withResult_u24lambda_u2d2$iv.fromInterop(handle$iv, result$iv);
            float[] result = result$iv;
            return new Rect(result[0], result[1], result[2], result[3]);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Rect[] fromInteropPointer$skiko(int size2, @NotNull Function2<? super InteropScope, Object, Unit> block) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            float[] result$iv = new float[size2];
            boolean $i$f$withResult = false;
            boolean $i$f$interopScope22 = false;
            InteropScope $this$withResult_u24lambda_u2d2$iv = theScope.INSTANCE;
            boolean bl = false;
            Object handle$iv = $this$withResult_u24lambda_u2d2$iv.toInterop(result$iv);
            block.invoke((Object)$this$withResult_u24lambda_u2d2$iv, handle$iv);
            $this$withResult_u24lambda_u2d2$iv.fromInterop(handle$iv, result$iv);
            float[] result = result$iv;
            Iterable $this$map$iv = CollectionsKt.chunked((Iterable)ArraysKt.toList((float[])result), (int)4);
            boolean $i$f$map = false;
            Iterable $i$f$interopScope22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $dstr$left$top$right$bottom;
                List list = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void var13_15 = $dstr$left$top$right$bottom;
                boolean bl3 = false;
                float left = ((Number)var13_15.get(0)).floatValue();
                void var14_18 = $dstr$left$top$right$bottom;
                boolean bl4 = false;
                float top = ((Number)var14_18.get(1)).floatValue();
                void var16_22 = $dstr$left$top$right$bottom;
                boolean bl5 = false;
                float right = ((Number)var16_22.get(2)).floatValue();
                void var17_23 = $dstr$left$top$right$bottom;
                boolean bl6 = false;
                float bottom = ((Number)var17_23.get(3)).floatValue();
                Rect rect2 = new Rect(left, right, top, bottom);
                collection.add(rect2);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Rect[] rectArray = thisCollection$iv.toArray(new Rect[0]);
            if (rectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return rectArray;
        }

        @Nullable
        public final Rect fromInteropPointerNullable$skiko(@NotNull Function1<Object, Boolean> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Ref.BooleanRef result = new Ref.BooleanRef();
            result.element = true;
            Rect rect2 = this.fromInteropPointer$skiko((Function2<? super InteropScope, Object, Unit>)((Function2)new Function2<InteropScope, Object, Unit>(result, block){
                final /* synthetic */ Ref.BooleanRef $result;
                final /* synthetic */ Function1<Object, Boolean> $block;
                {
                    this.$result = $result;
                    this.$block = $block;
                    super(2);
                }

                public final void invoke(@NotNull InteropScope $this$fromInteropPointer, @Nullable Object it) {
                    Intrinsics.checkNotNullParameter((Object)$this$fromInteropPointer, (String)"$this$fromInteropPointer");
                    this.$result.element = (Boolean)this.$block.invoke(it);
                }
            }));
            return result.element ? rect2 : (Rect)null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

