/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoGestureEvent;
import org.jetbrains.skiko.SkikoInputEvent;
import org.jetbrains.skiko.SkikoKeyboardEvent;
import org.jetbrains.skiko.SkikoPointerEvent;
import org.jetbrains.skiko.SkikoView;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0013H\u0016J(\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/skiko/GenericSkikoView;", "Lorg/jetbrains/skiko/SkikoView;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "app", "(Lorg/jetbrains/skiko/SkiaLayer;Lorg/jetbrains/skiko/SkikoView;)V", "getApp", "()Lorg/jetbrains/skiko/SkikoView;", "getLayer", "()Lorg/jetbrains/skiko/SkiaLayer;", "onGestureEvent", "", "event", "Lorg/jetbrains/skiko/SkikoGestureEvent;", "onInputEvent", "Lorg/jetbrains/skiko/SkikoInputEvent;", "onKeyboardEvent", "Lorg/jetbrains/skiko/SkikoKeyboardEvent;", "onPointerEvent", "Lorg/jetbrains/skiko/SkikoPointerEvent;", "onRender", "canvas", "Lorg/jetbrains/skia/Canvas;", "width", "", "height", "nanoTime", "", "skiko"})
public class GenericSkikoView
implements SkikoView {
    @NotNull
    private final SkiaLayer layer;
    @NotNull
    private final SkikoView app;

    public GenericSkikoView(@NotNull SkiaLayer layer, @NotNull SkikoView app) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        this.layer = layer;
        this.app = app;
    }

    @NotNull
    public final SkiaLayer getLayer() {
        return this.layer;
    }

    @NotNull
    public final SkikoView getApp() {
        return this.app;
    }

    @Override
    public void onRender(@NotNull Canvas canvas, int width2, int height2, long nanoTime) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        float contentScale = this.layer.getContentScale();
        canvas.scale(contentScale, contentScale);
        this.app.onRender(canvas, (int)((float)width2 / contentScale), (int)((float)height2 / contentScale), nanoTime);
        this.layer.needRedraw();
    }

    @Override
    public void onInputEvent(@NotNull SkikoInputEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.app.onInputEvent(event);
    }

    @Override
    public void onKeyboardEvent(@NotNull SkikoKeyboardEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.app.onKeyboardEvent(event);
    }

    @Override
    public void onPointerEvent(@NotNull SkikoPointerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.app.onPointerEvent(event);
    }

    @Override
    public void onGestureEvent(@NotNull SkikoGestureEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.app.onGestureEvent(event);
    }
}

