/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia.svg;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Point;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.svg.SVGLength;
import org.jetbrains.skia.svg.SVGLengthType;
import org.jetbrains.skia.svg.SVGLengthUnit;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u0015J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0006J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0006R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006$"}, d2={"Lorg/jetbrains/skia/svg/SVGLengthContext;", "", "size", "Lorg/jetbrains/skia/Point;", "(Lorg/jetbrains/skia/Point;)V", "width", "", "height", "dpi", "(FFF)V", "getDpi", "()F", "getHeight", "getWidth", "equals", "", "other", "hashCode", "", "resolve", "length", "Lorg/jetbrains/skia/svg/SVGLength;", "type", "Lorg/jetbrains/skia/svg/SVGLengthType;", "resolveRect", "Lorg/jetbrains/skia/Rect;", "x", "y", "toString", "", "withDpi", "_dpi", "withHeight", "_height", "withWidth", "_width", "skiko"})
public final class SVGLengthContext {
    private final float width;
    private final float height;
    private final float dpi;

    public SVGLengthContext(float width2, float height2, float dpi) {
        this.width = width2;
        this.height = height2;
        this.dpi = dpi;
    }

    public /* synthetic */ SVGLengthContext(float f, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f3 = 90.0f;
        }
        this(f, f2, f3);
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getDpi() {
        return this.dpi;
    }

    public SVGLengthContext(@NotNull Point size2) {
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        this(size2.getX(), size2.getY(), 90.0f);
    }

    public final float resolve(@NotNull SVGLength length, @NotNull SVGLengthType type) {
        float f;
        Intrinsics.checkNotNullParameter((Object)length, (String)"length");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[length.getUnit().ordinal()]) {
            case 1: {
                f = length.getValue();
                break;
            }
            case 2: {
                f = length.getValue();
                break;
            }
            case 3: {
                switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
                    case 1: {
                        return length.getValue() * this.width / 100.0f;
                    }
                    case 2: {
                        return length.getValue() * this.height / 100.0f;
                    }
                    case 3: {
                        return (float)((double)length.getValue() * Math.hypot(this.width, this.height) / Math.sqrt(2.0) / 100.0);
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 4: {
                f = length.getValue() * this.dpi / 2.54f;
                break;
            }
            case 5: {
                f = length.getValue() * this.dpi / 25.4f;
                break;
            }
            case 6: {
                f = length.getValue() * this.dpi;
                break;
            }
            case 7: {
                f = length.getValue() * this.dpi / 72.272f;
                break;
            }
            case 8: {
                f = length.getValue() * this.dpi * 12.0f / 72.272f;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SVGLengthUnit: " + length.getUnit());
            }
        }
        return f;
    }

    @NotNull
    public final Rect resolveRect(@NotNull SVGLength x2, @NotNull SVGLength y2, @NotNull SVGLength width2, @NotNull SVGLength height2) {
        Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y2, (String)"y");
        Intrinsics.checkNotNullParameter((Object)width2, (String)"width");
        Intrinsics.checkNotNullParameter((Object)height2, (String)"height");
        return Rect.Companion.makeXYWH(this.resolve(x2, SVGLengthType.HORIZONTAL), this.resolve(y2, SVGLengthType.VERTICAL), this.resolve(width2, SVGLengthType.HORIZONTAL), this.resolve(height2, SVGLengthType.VERTICAL));
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SVGLengthContext)) {
            return false;
        }
        if (Float.compare(this.width, ((SVGLengthContext)other).width) != 0) {
            return false;
        }
        if (Float.compare(this.height, ((SVGLengthContext)other).height) != 0) {
            return false;
        }
        return Float.compare(this.dpi, ((SVGLengthContext)other).dpi) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * PRIME + Float.floatToIntBits(this.width);
        result = result * PRIME + Float.floatToIntBits(this.height);
        result = result * PRIME + Float.floatToIntBits(this.dpi);
        return result;
    }

    @NotNull
    public String toString() {
        return "SVGLengthContext(_width=" + this.width + ", _height=" + this.height + ", _dpi=" + this.dpi + ")";
    }

    @NotNull
    public final SVGLengthContext withWidth(float _width) {
        return this.width == _width ? this : new SVGLengthContext(_width, this.height, this.dpi);
    }

    @NotNull
    public final SVGLengthContext withHeight(float _height) {
        return this.height == _height ? this : new SVGLengthContext(this.width, _height, this.dpi);
    }

    @NotNull
    public final SVGLengthContext withDpi(float _dpi) {
        return this.dpi == _dpi ? this : new SVGLengthContext(this.width, this.height, _dpi);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SVGLengthUnit.values().length];
            nArray[SVGLengthUnit.NUMBER.ordinal()] = 1;
            nArray[SVGLengthUnit.PX.ordinal()] = 2;
            nArray[SVGLengthUnit.PERCENTAGE.ordinal()] = 3;
            nArray[SVGLengthUnit.CM.ordinal()] = 4;
            nArray[SVGLengthUnit.MM.ordinal()] = 5;
            nArray[SVGLengthUnit.IN.ordinal()] = 6;
            nArray[SVGLengthUnit.PT.ordinal()] = 7;
            nArray[SVGLengthUnit.PC.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SVGLengthType.values().length];
            nArray[SVGLengthType.HORIZONTAL.ordinal()] = 1;
            nArray[SVGLengthType.VERTICAL.ordinal()] = 2;
            nArray[SVGLengthType.OTHER.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

