/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.awt.Font;
import java.awt.color.ColorSpace;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorType;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.Pixmap;
import org.jetbrains.skia.Typeface;
import org.jetbrains.skia.impl.BufferUtil;
import org.jetbrains.skiko.AwtFontManager;
import org.jetbrains.skiko.Convertors_jvmKt;
import org.jetbrains.skiko.DirectDataBuffer;
import org.jetbrains.skiko.SkikoInputEvent;
import org.jetbrains.skiko.SkikoInputModifiers;
import org.jetbrains.skiko.SkikoKey;
import org.jetbrains.skiko.SkikoKeyboardEvent;
import org.jetbrains.skiko.SkikoKeyboardEventKind;
import org.jetbrains.skiko.SkikoMouseButtons;
import org.jetbrains.skiko.SkikoPointerEvent;
import org.jetbrains.skiko.SkikoPointerEventKind;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0006\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\f\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\f\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0017\u001a\n\u0010\u0018\u001a\u00020\u0017*\u00020\u0016\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\u0017\u001a\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001dH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"toSkikoEvent", "Lorg/jetbrains/skiko/SkikoKeyboardEvent;", "event", "Ljava/awt/event/KeyEvent;", "Lorg/jetbrains/skiko/SkikoPointerEvent;", "Ljava/awt/event/MouseEvent;", "Ljava/awt/event/MouseWheelEvent;", "toSkikoKey", "", "toSkikoModifiers", "Lorg/jetbrains/skiko/SkikoInputModifiers;", "modifiers", "(I)I", "toSkikoMouseButtons", "Lorg/jetbrains/skiko/SkikoMouseButtons;", "buttons", "toSkikoTypeEvent", "Lorg/jetbrains/skiko/SkikoInputEvent;", "Ljava/awt/event/InputMethodEvent;", "keyEvent", "typeEvent", "toBitmap", "Lorg/jetbrains/skia/Bitmap;", "Ljava/awt/image/BufferedImage;", "toBufferedImage", "toImage", "Lorg/jetbrains/skia/Image;", "toSkikoTypeface", "Lorg/jetbrains/skia/Typeface;", "Ljava/awt/Font;", "(Ljava/awt/Font;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "skiko"})
public final class Convertors_jvmKt {
    @NotNull
    public static final BufferedImage toBufferedImage(@NotNull Bitmap $this$toBufferedImage) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)$this$toBufferedImage, (String)"<this>");
        Pixmap pixmap = $this$toBufferedImage.peekPixels();
        Intrinsics.checkNotNull((Object)pixmap);
        long pixelsNativePointer = pixmap.getAddr();
        ByteBuffer pixelsBuffer = BufferUtil.INSTANCE.getByteBufferFromPointer(pixelsNativePointer, $this$toBufferedImage.getRowBytes() * $this$toBufferedImage.getHeight());
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toBufferedImage.getColorInfo().getColorType().ordinal()]) {
            case 1: {
                int[] nArray2 = new int[]{0, 1, 2, 3};
                nArray = nArray2;
                break;
            }
            case 2: {
                int[] nArray2 = new int[]{2, 1, 0, 3};
                nArray = nArray2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported color type " + $this$toBufferedImage.getColorInfo().getColorType());
            }
        }
        int[] order = nArray;
        WritableRaster raster = Raster.createInterleavedRaster(new DirectDataBuffer(pixelsBuffer), $this$toBufferedImage.getWidth(), $this$toBufferedImage.getHeight(), $this$toBufferedImage.getWidth() * 4, 4, order, null);
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
        ColorModel colorModel2 = colorModel;
        WritableRaster writableRaster = raster;
        Intrinsics.checkNotNull((Object)writableRaster);
        return new BufferedImage(colorModel2, writableRaster, false, null);
    }

    @NotNull
    public static final Bitmap toBitmap(@NotNull BufferedImage $this$toBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$toBitmap, (String)"<this>");
        int bytesPerPixel = 4;
        byte[] pixels = new byte[$this$toBitmap.getWidth() * $this$toBitmap.getHeight() * bytesPerPixel];
        int k = 0;
        int n = 0;
        int n2 = $this$toBitmap.getHeight();
        while (n < n2) {
            int y2 = n++;
            int n3 = 0;
            int n4 = $this$toBitmap.getWidth();
            while (n3 < n4) {
                int x2 = n3++;
                int argb = $this$toBitmap.getRGB(x2, y2);
                int a = argb >> 24 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb >> 0 & 0xFF;
                int n5 = k;
                k = n5 + 1;
                pixels[n5] = (byte)b;
                n5 = k;
                k = n5 + 1;
                pixels[n5] = (byte)g;
                n5 = k;
                k = n5 + 1;
                pixels[n5] = (byte)r;
                n5 = k;
                k = n5 + 1;
                pixels[n5] = (byte)a;
            }
        }
        Bitmap bitmap = new Bitmap();
        bitmap.allocPixels(ImageInfo.Companion.makeS32($this$toBitmap.getWidth(), $this$toBitmap.getHeight(), ColorAlphaType.UNPREMUL));
        bitmap.installPixels(pixels);
        return bitmap;
    }

    @NotNull
    public static final Image toImage(@NotNull BufferedImage $this$toImage) {
        Intrinsics.checkNotNullParameter((Object)$this$toImage, (String)"<this>");
        return Image.Companion.makeFromBitmap(Convertors_jvmKt.toBitmap($this$toImage));
    }

    @NotNull
    public static final SkikoPointerEvent toSkikoEvent(@NotNull MouseEvent event) {
        SkikoPointerEventKind skikoPointerEventKind;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        double d = event.getX();
        double d2 = event.getY();
        int n = Convertors_jvmKt.toSkikoMouseButtons(event.getModifiersEx());
        int n2 = Convertors_jvmKt.toSkikoModifiers(event.getModifiersEx());
        switch (event.getID()) {
            case 501: {
                skikoPointerEventKind = SkikoPointerEventKind.DOWN;
                break;
            }
            case 502: {
                skikoPointerEventKind = SkikoPointerEventKind.UP;
                break;
            }
            case 506: {
                skikoPointerEventKind = SkikoPointerEventKind.DRAG;
                break;
            }
            case 503: {
                skikoPointerEventKind = SkikoPointerEventKind.MOVE;
                break;
            }
            case 504: {
                skikoPointerEventKind = SkikoPointerEventKind.ENTER;
                break;
            }
            case 505: {
                skikoPointerEventKind = SkikoPointerEventKind.EXIT;
                break;
            }
            default: {
                skikoPointerEventKind = SkikoPointerEventKind.UNKNOWN;
            }
        }
        return new SkikoPointerEvent(d, d2, 0.0, 0.0, n, n2, skikoPointerEventKind, event.getWhen(), event, 12, null);
    }

    @NotNull
    public static final SkikoPointerEvent toSkikoEvent(@NotNull MouseWheelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        double scrollAmount = event.getPreciseWheelRotation();
        int modifiers = Convertors_jvmKt.toSkikoModifiers(event.getModifiersEx());
        boolean isShiftPressed = SkikoInputModifiers.has-TH98kIg(modifiers, SkikoInputModifiers.Companion.getSHIFT-kKhcapQ());
        double deltaX = isShiftPressed ? scrollAmount : 0.0;
        double deltaY = isShiftPressed ? 0.0 : scrollAmount;
        return new SkikoPointerEvent(event.getX(), event.getY(), deltaX, deltaY, Convertors_jvmKt.toSkikoMouseButtons(event.getModifiersEx()), modifiers, event.getID() == 507 ? SkikoPointerEventKind.SCROLL : SkikoPointerEventKind.UNKNOWN, event.getWhen(), event, null);
    }

    @NotNull
    public static final SkikoKeyboardEvent toSkikoEvent(@NotNull KeyEvent event) {
        SkikoKeyboardEventKind skikoKeyboardEventKind;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SkikoKey skikoKey = SkikoKey.Companion.valueOf(Convertors_jvmKt.toSkikoKey(event));
        int n = Convertors_jvmKt.toSkikoModifiers(event.getModifiersEx());
        switch (event.getID()) {
            case 401: {
                skikoKeyboardEventKind = SkikoKeyboardEventKind.DOWN;
                break;
            }
            case 402: {
                skikoKeyboardEventKind = SkikoKeyboardEventKind.UP;
                break;
            }
            default: {
                skikoKeyboardEventKind = SkikoKeyboardEventKind.UNKNOWN;
            }
        }
        return new SkikoKeyboardEvent(skikoKey, n, skikoKeyboardEventKind, event.getWhen(), event, null);
    }

    @NotNull
    public static final SkikoInputEvent toSkikoTypeEvent(@NotNull KeyEvent typeEvent, @Nullable KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)typeEvent, (String)"typeEvent");
        int key = -1;
        int modifiers = SkikoInputModifiers.Companion.getEMPTY-kKhcapQ();
        if (keyEvent != null) {
            key = Convertors_jvmKt.toSkikoKey(keyEvent);
            modifiers = Convertors_jvmKt.toSkikoModifiers(keyEvent.getModifiersEx());
        }
        return new SkikoInputEvent(String.valueOf(typeEvent.getKeyChar()), SkikoKey.Companion.valueOf(key), modifiers, SkikoKeyboardEventKind.TYPE, typeEvent, null);
    }

    @NotNull
    public static final SkikoInputEvent toSkikoTypeEvent(@NotNull InputMethodEvent event, @Nullable KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int key = -1;
        int modifiers = SkikoInputModifiers.Companion.getEMPTY-kKhcapQ();
        if (keyEvent != null) {
            key = Convertors_jvmKt.toSkikoKey(keyEvent);
            modifiers = Convertors_jvmKt.toSkikoModifiers(keyEvent.getModifiersEx());
        }
        return new SkikoInputEvent("", SkikoKey.Companion.valueOf(key), modifiers, SkikoKeyboardEventKind.TYPE, event, null);
    }

    private static final int toSkikoMouseButtons(int buttons) {
        int result = 0;
        if ((buttons & 0x400) != 0) {
            result |= SkikoMouseButtons.Companion.getLEFT-CuO1FYg();
        }
        if ((buttons & 0x800) != 0) {
            result |= SkikoMouseButtons.Companion.getRIGHT-CuO1FYg();
        }
        if ((buttons & 0x1000) != 0) {
            result |= SkikoMouseButtons.Companion.getMIDDLE-CuO1FYg();
        }
        return SkikoMouseButtons.constructor-impl(result);
    }

    private static final int toSkikoModifiers(int modifiers) {
        int result = 0;
        if ((modifiers & 0x200) != 0) {
            result |= SkikoInputModifiers.Companion.getALT-kKhcapQ();
        }
        if ((modifiers & 0x40) != 0) {
            result |= SkikoInputModifiers.Companion.getSHIFT-kKhcapQ();
        }
        if ((modifiers & 0x80) != 0) {
            result |= SkikoInputModifiers.Companion.getCONTROL-kKhcapQ();
        }
        if ((modifiers & 0x100) != 0) {
            result |= SkikoInputModifiers.Companion.getMETA-kKhcapQ();
        }
        return SkikoInputModifiers.constructor-impl(result);
    }

    private static final int toSkikoKey(KeyEvent event) {
        int key = event.getKeyCode();
        int side = event.getKeyLocation();
        if (side == 3 && (key == SkikoKey.KEY_LEFT_CONTROL.getValue() || key == SkikoKey.KEY_LEFT_SHIFT.getValue() || key == SkikoKey.KEY_LEFT_META.getValue())) {
            key |= Integer.MIN_VALUE;
        }
        if (side == 4 && key == SkikoKey.KEY_ENTER.getValue()) {
            key |= Integer.MIN_VALUE;
        }
        return key;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object toSkikoTypeface(@NotNull Font var0, @NotNull Continuation<? super Typeface> var1_1) {
        if (!(var1_1 instanceof toSkikoTypeface.1)) ** GOTO lbl-1000
        var5_2 = var1_1;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var1_1){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Convertors_jvmKt.toSkikoTypeface(null, (Continuation<? super Typeface>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = AwtFontManager.Companion.getDEFAULT().findFontFile($this$toSkikoTypeface, (Continuation<? super File>)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                v1 = (File)v0;
                if (v1 == null) {
                    return null;
                }
                file = v1;
                data = FilesKt.readBytes((File)file);
                return Typeface.Companion.makeFromData$default(Typeface.Companion, Data.Companion.makeFromBytes$default(Data.Companion, data, 0, 0, 6, null), 0, 2, null);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColorType.values().length];
            nArray[ColorType.RGB_888X.ordinal()] = 1;
            nArray[ColorType.BGRA_8888.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

