/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.context.JvmContextHandler;
import org.jetbrains.skiko.redrawer.AngleRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/skiko/context/AngleContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "angleRedrawer", "Lorg/jetbrains/skiko/redrawer/AngleRedrawer;", "getAngleRedrawer", "()Lorg/jetbrains/skiko/redrawer/AngleRedrawer;", "device", "", "getDevice", "()J", "setDevice", "(J)V", "flush", "", "initCanvas", "initContext", "", "skiko"})
public final class AngleContextHandler
extends JvmContextHandler {
    private long device;

    public AngleContextHandler(@NotNull SkiaLayer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super(layer);
    }

    @NotNull
    public final AngleRedrawer getAngleRedrawer() {
        Redrawer redrawer = this.getLayer().getRedrawer$skiko();
        Intrinsics.checkNotNull((Object)redrawer);
        return (AngleRedrawer)redrawer;
    }

    public final long getDevice() {
        return this.device;
    }

    public final void setDevice(long l) {
        this.device = l;
    }

    @Override
    protected boolean initContext() {
        try {
            if (this.getContext() == null) {
                this.device = this.getAngleRedrawer().createDevice();
                if (this.device == 0L) {
                    throw new RenderException("Failed to create Angle device.", null, 2, null);
                }
                this.setContext(this.getAngleRedrawer().makeContext());
            }
        }
        catch (Exception e) {
            System.out.println((Object)(e.getMessage() + "\nFailed to create Skia Angle context!"));
            return false;
        }
        return true;
    }

    @Override
    protected void initCanvas() {
        this.dispose();
        float scale = this.getLayer().getContentScale();
        int w = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)0);
        int h = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)0);
        this.setRenderTarget(this.getAngleRedrawer().makeRenderTarget(w, h));
        DirectContext directContext = this.getContext();
        Intrinsics.checkNotNull((Object)directContext);
        BackendRenderTarget backendRenderTarget = this.getRenderTarget();
        Intrinsics.checkNotNull((Object)backendRenderTarget);
        this.setSurface(Surface.Companion.makeFromBackendRenderTarget$default(Surface.Companion, directContext, backendRenderTarget, SurfaceOrigin.BOTTOM_LEFT, SurfaceColorFormat.RGBA_8888, ColorSpace.Companion.getSRGB(), null, 32, null));
        Surface surface = this.getSurface();
        Intrinsics.checkNotNull((Object)surface);
        this.setCanvas(surface.getCanvas());
    }

    @Override
    protected void flush() {
        super.flush();
        this.getAngleRedrawer().finishFrame();
    }
}

