/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia.impl;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\f\u001a\u00020\tJ\u0014\u0010\r\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tJ\u0014\u0010\u000e\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tJ\u0014\u0010\u000f\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tJ\u0014\u0010\u0010\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tJ\u0014\u0010\u0011\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/skia/impl/Log;", "", "()V", "_level", "", "_log", "", "level", "prefix", "", "s", "Ljava/util/function/Supplier;", "_time", "debug", "error", "info", "trace", "warn", "skiko"})
public final class Log {
    @NotNull
    public static final Log INSTANCE;
    private static int _level;

    private Log() {
    }

    public final void trace(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this._log(1, "[TRACE]", s);
    }

    public final void debug(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this._log(2, "[DEBUG]", s);
    }

    public final void info(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this._log(3, "[INFO ]", s);
    }

    public final void warn(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this._log(4, "[WARN ]", s);
    }

    public final void error(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this._log(5, "[ERROR]", s);
    }

    public final void trace(@NotNull Supplier<String> s) {
        Intrinsics.checkNotNullParameter(s, (String)"s");
        this._log(1, "[TRACE]", s);
    }

    public final void debug(@NotNull Supplier<String> s) {
        Intrinsics.checkNotNullParameter(s, (String)"s");
        this._log(2, "[DEBUG]", s);
    }

    public final void info(@NotNull Supplier<String> s) {
        Intrinsics.checkNotNullParameter(s, (String)"s");
        this._log(3, "[INFO ]", s);
    }

    public final void warn(@NotNull Supplier<String> s) {
        Intrinsics.checkNotNullParameter(s, (String)"s");
        this._log(4, "[WARN ]", s);
    }

    public final void error(@NotNull Supplier<String> s) {
        Intrinsics.checkNotNullParameter(s, (String)"s");
        this._log(5, "[ERROR]", s);
    }

    @NotNull
    public final String _time() {
        String string = ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"now(ZoneOffset.UTC).form\u2026imeFormatter.ISO_INSTANT)");
        return string;
    }

    public final void _log(int level, @NotNull String prefix, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (level >= _level) {
            System.out.println((Object)(this._time() + " " + prefix + " " + s));
        }
    }

    public final void _log(int level, @NotNull String prefix, @NotNull Supplier<String> s) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(s, (String)"s");
        if (level >= _level) {
            System.out.println((Object)(this._time() + " " + prefix + " " + s.get()));
        }
    }

    static {
        int n;
        INSTANCE = new Log();
        String property = System.getProperty("skija.logLevel");
        if (Intrinsics.areEqual((Object)"ALL", (Object)property)) {
            n = 0;
        } else if (Intrinsics.areEqual((Object)"TRACE", (Object)property)) {
            n = 1;
        } else if (Intrinsics.areEqual((Object)"DEBUG", (Object)property)) {
            n = 2;
        } else if (Intrinsics.areEqual((Object)"INFO", (Object)property)) {
            n = 3;
        } else if (property == null || Intrinsics.areEqual((Object)"WARN", (Object)property)) {
            n = 4;
        } else if (Intrinsics.areEqual((Object)"ERROR", (Object)property)) {
            n = 5;
        } else if (Intrinsics.areEqual((Object)"NONE", (Object)property)) {
            n = 6;
        } else {
            throw new IllegalArgumentException("Unknown log level: " + property);
        }
        _level = n;
    }
}

