/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B'\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010\u0016\u001a\u00020\u0003J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\u0016\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\tJ\u0006\u0010\u001a\u001a\u00020\u0006J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\tJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\tJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\tJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\tR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006&"}, d2={"Lorg/jetbrains/skia/Color4f;", "", "rgba", "", "([F)V", "c", "", "(I)V", "r", "", "g", "b", "a", "(FFFF)V", "getA", "()F", "getB", "getG", "getR", "equals", "", "other", "flatten", "hashCode", "makeLerp", "weight", "toColor", "toString", "", "withA", "_a", "withB", "_b", "withG", "_g", "withR", "_r", "Companion", "skiko"})
public final class Color4f {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float r;
    private final float g;
    private final float b;
    private final float a;

    public Color4f(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public /* synthetic */ Color4f(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        this(f, f2, f3, f4);
    }

    public final float getR() {
        return this.r;
    }

    public final float getG() {
        return this.g;
    }

    public final float getB() {
        return this.b;
    }

    public final float getA() {
        return this.a;
    }

    public Color4f(@NotNull float[] rgba) {
        Intrinsics.checkNotNullParameter((Object)rgba, (String)"rgba");
        this(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    public Color4f(int c) {
        this((float)(c >> 16 & 0xFF) / 255.0f, (float)(c >> 8 & 0xFF) / 255.0f, (float)(c & 0xFF) / 255.0f, (float)(c >> 24 & 0xFF) / 255.0f);
    }

    public final int toColor() {
        return (int)Math.rint(this.a * 255.0f) << 24 | (int)Math.rint(this.r * 255.0f) << 16 | (int)Math.rint(this.g * 255.0f) << 8 | (int)Math.rint(this.b * 255.0f);
    }

    @NotNull
    public final float[] flatten() {
        float[] fArray = new float[]{this.r, this.g, this.b, this.a};
        return fArray;
    }

    @NotNull
    public final Color4f makeLerp(@NotNull Color4f other, float weight) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Color4f(this.r + (other.r - this.r) * weight, this.g + (other.g - this.g) * weight, this.b + (other.b - this.b) * weight, this.a + (other.a - this.a) * weight);
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Color4f)) {
            return false;
        }
        if (Float.compare(this.r, ((Color4f)other).r) != 0) {
            return false;
        }
        if (Float.compare(this.g, ((Color4f)other).g) != 0) {
            return false;
        }
        if (Float.compare(this.b, ((Color4f)other).b) != 0) {
            return false;
        }
        return Float.compare(this.a, ((Color4f)other).a) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * PRIME + Float.floatToIntBits(this.r);
        result = result * PRIME + Float.floatToIntBits(this.g);
        result = result * PRIME + Float.floatToIntBits(this.b);
        result = result * PRIME + Float.floatToIntBits(this.a);
        return result;
    }

    @NotNull
    public String toString() {
        return "Color4f(_r=" + this.r + ", _g=" + this.g + ", _b=" + this.b + ", _a=" + this.a + ')';
    }

    @NotNull
    public final Color4f withR(float _r) {
        return this.r == _r ? this : new Color4f(_r, this.g, this.b, this.a);
    }

    @NotNull
    public final Color4f withG(float _g) {
        return this.g == _g ? this : new Color4f(this.r, _g, this.b, this.a);
    }

    @NotNull
    public final Color4f withB(float _b) {
        return this.b == _b ? this : new Color4f(this.r, this.g, _b, this.a);
    }

    @NotNull
    public final Color4f withA(float _a) {
        return this.a == _a ? this : new Color4f(this.r, this.g, this.b, _a);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/skia/Color4f$Companion;", "", "()V", "flattenArray", "", "colors", "", "Lorg/jetbrains/skia/Color4f;", "([Lorg/jetbrains/skia/Color4f;)[F", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final float[] flattenArray(@NotNull Color4f[] colors) {
            Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
            float[] arr = new float[colors.length * 4];
            int n = 0;
            int n2 = colors.length;
            while (n < n2) {
                int i = n++;
                arr[i * 4] = colors[i].getR();
                arr[i * 4 + 1] = colors[i].getG();
                arr[i * 4 + 2] = colors[i].getB();
                arr[i * 4 + 3] = colors[i].getA();
            }
            return arr;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

