/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Actuals_jvmKt;
import org.jetbrains.skia.FontFeature;
import org.jetbrains.skia.FourByteTag;
import org.jetbrains.skia.impl.InteropScope;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B*\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rB(\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u0005H\u0016J\r\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\b\u0010\u001f\u001a\u00020\u0003H\u0016J\u0017\u0010 \u001a\b\u0018\u00010\u0001j\u0002`!*\u00020\"H\u0000\u00a2\u0006\u0002\b#R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\b\u001a\u00020\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0012\u0010\u0011R\u001c\u0010\u0006\u001a\u00020\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006%"}, d2={"Lorg/jetbrains/skia/FontFeature;", "", "feature", "", "value", "", "start", "Lkotlin/UInt;", "end", "(Ljava/lang/String;IIILkotlin/jvm/internal/DefaultConstructorMarker;)V", "(Ljava/lang/String;I)V", "", "(Ljava/lang/String;Z)V", "(Ljava/lang/String;)V", "_tag", "(IIIILkotlin/jvm/internal/DefaultConstructorMarker;)V", "get_tag", "()I", "getEnd-pVg5ArA", "I", "getStart-pVg5ArA", "tag", "getTag", "()Ljava/lang/String;", "getValue", "equals", "other", "hashCode", "toInteropIntArray", "", "toInteropIntArray$skiko", "toString", "toInterop", "Lorg/jetbrains/skia/impl/InteropPointer;", "Lorg/jetbrains/skia/impl/InteropScope;", "toInterop$skiko", "Companion", "skiko"})
public final class FontFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int _tag;
    private final int value;
    private final int start;
    private final int end;
    public static final int GLOBAL_START = 0;
    public static final int GLOBAL_END = -1;
    @NotNull
    private static final FontFeature[] EMPTY = new FontFeature[0];
    @NotNull
    private static final Pattern _splitPattern = Actuals_jvmKt.compilePattern("\\s+");
    @NotNull
    private static final Pattern _featurePattern = Actuals_jvmKt.compilePattern("([-+])?([a-z0-9]{4})(?:\\[(\\d+)?:(\\d+)?\\])?(?:=(\\d+))?");
    private static final int signIx = 1;
    private static final int tagIx = 2;
    private static final int startIx = 3;
    private static final int endIx = 4;
    private static final int valueIx = 5;

    private FontFeature(int _tag, int value, int start2, int end) {
        this._tag = _tag;
        this.value = value;
        this.start = start2;
        this.end = end;
    }

    public final int get_tag() {
        return this._tag;
    }

    public final int getValue() {
        return this.value;
    }

    public final int getStart-pVg5ArA() {
        return this.start;
    }

    public final int getEnd-pVg5ArA() {
        return this.end;
    }

    private FontFeature(String feature, int value, int start2, int end) {
        this(FourByteTag.Companion.fromString(feature), value, start2, end, null);
    }

    public FontFeature(@NotNull String feature, int value) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        this(FourByteTag.Companion.fromString(feature), value, 0, -1, null);
    }

    public FontFeature(@NotNull String feature, boolean value) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        this(FourByteTag.Companion.fromString(feature), value ? 1 : 0, 0, -1, null);
    }

    public FontFeature(@NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        this(FourByteTag.Companion.fromString(feature), 1, 0, -1, null);
    }

    @NotNull
    public final String getTag() {
        return FourByteTag.Companion.toString(this._tag);
    }

    @NotNull
    public String toString() {
        String range = "";
        if (Integer.compareUnsigned(this.getStart-pVg5ArA(), 0) > 0 || Integer.compareUnsigned(this.getEnd-pVg5ArA(), -1) < 0) {
            range = "" + '[' + (Integer.compareUnsigned(this.getStart-pVg5ArA(), 0) > 0 ? UInt.box-impl((int)this.getStart-pVg5ArA()) : (Comparable)((Object)"")) + ':' + (Integer.compareUnsigned(this.getEnd-pVg5ArA(), -1) < 0 ? UInt.box-impl((int)this.getEnd-pVg5ArA()) : (Comparable)((Object)"")) + ']';
        }
        String valuePrefix = "";
        String valueSuffix = "";
        if (this.value == 0) {
            valuePrefix = "-";
        } else if (this.value == 1) {
            valuePrefix = "+";
        } else {
            valueSuffix = Intrinsics.stringPlus((String)"=", (Object)this.value);
        }
        return "FontFeature(" + valuePrefix + this._tag + range + valueSuffix + ')';
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FontFeature)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getTag(), (Object)((FontFeature)other).getTag())) {
            return false;
        }
        if (this.value != ((FontFeature)other).value) {
            return false;
        }
        if (this.getStart-pVg5ArA() != ((FontFeature)other).getStart-pVg5ArA()) {
            return false;
        }
        return this.getEnd-pVg5ArA() == ((FontFeature)other).getEnd-pVg5ArA();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * PRIME + Integer.hashCode(this._tag);
        result = result * PRIME + this.value;
        result = result * PRIME + UInt.constructor-impl((int)(UInt.constructor-impl((int)(this.getStart-pVg5ArA() >>> 16)) ^ this.getStart-pVg5ArA()));
        result = result * PRIME + UInt.constructor-impl((int)(UInt.constructor-impl((int)(this.getEnd-pVg5ArA() >>> 16)) ^ this.getEnd-pVg5ArA()));
        return result;
    }

    @NotNull
    public final int[] toInteropIntArray$skiko() {
        int[] nArray = new int[]{this._tag, this.value, this.getStart-pVg5ArA(), this.getEnd-pVg5ArA()};
        return nArray;
    }

    @Nullable
    public final Object toInterop$skiko(@NotNull InteropScope $this$toInterop) {
        Intrinsics.checkNotNullParameter((Object)$this$toInterop, (String)"<this>");
        return $this$toInterop.toInterop(this.toInteropIntArray$skiko());
    }

    public /* synthetic */ FontFeature(int _tag, int value, int start2, int end, DefaultConstructorMarker $constructor_marker) {
        this(_tag, value, start2, end);
    }

    public /* synthetic */ FontFeature(String feature, int value, int start2, int end, DefaultConstructorMarker $constructor_marker) {
        this(feature, value, start2, end);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0019\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010\"J\u000e\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020!J\u0019\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010\"J)\u0010&\u001a\b\u0018\u00010\u0001j\u0002`'*\u00020(2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0000\u00a2\u0006\u0004\b)\u0010*R\u001b\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\t\u001a\u00020\nX\u0086T\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0019\u0010\f\u001a\u00020\nX\u0086T\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0015\u0010\r\u001a\u00060\u000ej\u0002`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0012\u001a\u00060\u000ej\u0002`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006+"}, d2={"Lorg/jetbrains/skia/FontFeature$Companion;", "", "()V", "EMPTY", "", "Lorg/jetbrains/skia/FontFeature;", "getEMPTY", "()[Lorg/jetbrains/skia/FontFeature;", "[Lorg/jetbrains/skia/FontFeature;", "GLOBAL_END", "Lkotlin/UInt;", "I", "GLOBAL_START", "_featurePattern", "Ljava/util/regex/Pattern;", "Lorg/jetbrains/skia/Pattern;", "get_featurePattern", "()Ljava/util/regex/Pattern;", "_splitPattern", "get_splitPattern", "endIx", "", "signIx", "startIx", "tagIx", "valueIx", "fromInteropEncodedBy2Ints", "fontFeatures", "", "fromInteropEncodedBy2Ints$skiko", "([I)[Lorg/jetbrains/skia/FontFeature;", "parse", "str", "", "(Ljava/lang/String;)[Lorg/jetbrains/skia/FontFeature;", "parseOne", "s", "parseW3", "arrayOfFontFeaturesToInterop", "Lorg/jetbrains/skia/impl/InteropPointer;", "Lorg/jetbrains/skia/impl/InteropScope;", "arrayOfFontFeaturesToInterop$skiko", "(Lorg/jetbrains/skia/impl/InteropScope;[Lorg/jetbrains/skia/FontFeature;)Ljava/lang/Object;", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FontFeature[] getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final Pattern get_splitPattern() {
            return _splitPattern;
        }

        @NotNull
        public final Pattern get_featurePattern() {
            return _featurePattern;
        }

        @NotNull
        public final FontFeature parseOne(@NotNull String s) {
            int n;
            int start2;
            int n2;
            int value;
            int n3;
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            Matcher m = this.get_featurePattern().matcher(s);
            if (!m.matches()) {
                boolean $i$a$-require-FontFeature$Companion$parseOne$22 = false;
                String $i$a$-require-FontFeature$Companion$parseOne$22 = Intrinsics.stringPlus((String)"Can\u2019t parse FontFeature: ", (Object)s);
                throw new IllegalArgumentException($i$a$-require-FontFeature$Companion$parseOne$22.toString());
            }
            if (m.group(5) != null) {
                String string = m.group(5);
                Intrinsics.checkNotNull((Object)string);
                n3 = Integer.parseInt(string);
            } else {
                n3 = m.group(1) == null ? 1 : (value = Intrinsics.areEqual((Object)"-", (Object)m.group(1)) ? 0 : 1);
            }
            if (m.group(3) == null) {
                n2 = 0;
            } else {
                String string = m.group(3);
                Intrinsics.checkNotNull((Object)string);
                n2 = start2 = UStringsKt.toUInt((String)string);
            }
            if (m.group(4) == null) {
                n = -1;
            } else {
                String string = m.group(4);
                Intrinsics.checkNotNull((Object)string);
                n = UStringsKt.toUInt((String)string);
            }
            int end = n;
            String string = m.group(2);
            Intrinsics.checkNotNull((Object)string);
            return new FontFeature(string, value, start2, end, null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FontFeature[] parse(@NotNull String str) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            String[] stringArray = this.get_splitPattern().split(str);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"_splitPattern.split(str)");
            Object[] $this$map$iv = stringArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void s;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)s, (String)"s");
                collection.add(Companion.parseOne((String)s));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            FontFeature[] fontFeatureArray = thisCollection$iv.toArray(new FontFeature[0]);
            if (fontFeatureArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            return fontFeatureArray;
        }

        @NotNull
        public final FontFeature[] parseW3(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            String[] stringArray = new String[]{","};
            Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)StringsKt.splitToSequence$default((CharSequence)str, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (Function1)parseW3.1.INSTANCE));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            FontFeature[] fontFeatureArray = thisCollection$iv.toArray(new FontFeature[0]);
            if (fontFeatureArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            return fontFeatureArray;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Object arrayOfFontFeaturesToInterop$skiko(@NotNull InteropScope $this$arrayOfFontFeaturesToInterop, @Nullable FontFeature[] fontFeatures) {
            int n;
            Intrinsics.checkNotNullParameter((Object)$this$arrayOfFontFeaturesToInterop, (String)"<this>");
            int[] ints = new int[4 * (fontFeatures == null ? 0 : (n = fontFeatures.length))];
            if (fontFeatures != null) {
                FontFeature[] $this$forEachIndexed$iv = fontFeatures;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (FontFeature item$iv : $this$forEachIndexed$iv) {
                    void fontFeature;
                    int n2 = index$iv;
                    index$iv = n2 + 1;
                    FontFeature fontFeature2 = item$iv;
                    int ix = n2;
                    boolean bl = false;
                    int j = ix * 4;
                    ints[j] = fontFeature.get_tag();
                    ints[j + 1] = fontFeature.getValue();
                    ints[j + 2] = fontFeature.getStart-pVg5ArA();
                    ints[j + 3] = fontFeature.getEnd-pVg5ArA();
                }
            }
            return $this$arrayOfFontFeaturesToInterop.toInterop(ints);
        }

        @NotNull
        public final FontFeature[] fromInteropEncodedBy2Ints$skiko(@NotNull int[] fontFeatures) {
            Intrinsics.checkNotNullParameter((Object)fontFeatures, (String)"fontFeatures");
            int featuresCount = fontFeatures.length / 2;
            int n = 0;
            FontFeature[] fontFeatureArray = new FontFeature[featuresCount];
            while (n < featuresCount) {
                int n2 = n++;
                int j = n2 * 2;
                fontFeatureArray[n2] = new FontFeature(fontFeatures[j], fontFeatures[j + 1], 0, -1, null);
            }
            return fontFeatureArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

