/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.context.JvmContextHandler;
import org.jetbrains.skiko.redrawer.MetalRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0014J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/skiko/context/MetalContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "metalRedrawer", "Lorg/jetbrains/skiko/redrawer/MetalRedrawer;", "getMetalRedrawer", "()Lorg/jetbrains/skiko/redrawer/MetalRedrawer;", "flush", "", "initCanvas", "initContext", "", "rendererInfo", "", "skiko"})
public final class MetalContextHandler
extends JvmContextHandler {
    public MetalContextHandler(@NotNull SkiaLayer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super(layer);
    }

    @NotNull
    public final MetalRedrawer getMetalRedrawer() {
        Redrawer redrawer = this.getLayer().getRedrawer$skiko();
        Intrinsics.checkNotNull((Object)redrawer);
        return (MetalRedrawer)redrawer;
    }

    @Override
    protected boolean initContext() {
        try {
            if (this.getContext() == null) {
                this.setContext(this.getMetalRedrawer().makeContext());
                if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true")) {
                    System.out.println((Object)this.rendererInfo());
                }
            }
        }
        catch (Exception e) {
            System.out.println((Object)Intrinsics.stringPlus((String)e.getMessage(), (Object)"\nFailed to create Skia Metal context!"));
            return false;
        }
        return true;
    }

    @Override
    protected void initCanvas() {
        this.disposeCanvas();
        float scale = this.getLayer().getContentScale();
        int w = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)0);
        int h = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)0);
        if (w > 0 && h > 0) {
            this.setRenderTarget(this.getMetalRedrawer().makeRenderTarget(w, h));
            DirectContext directContext = this.getContext();
            Intrinsics.checkNotNull((Object)directContext);
            BackendRenderTarget backendRenderTarget = this.getRenderTarget();
            Intrinsics.checkNotNull((Object)backendRenderTarget);
            Surface surface = Surface.Companion.makeFromBackendRenderTarget$default(Surface.Companion, directContext, backendRenderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), null, 32, null);
            if (surface == null) {
                throw new RenderException("Cannot create surface", null, 2, null);
            }
            this.setSurface(surface);
            Surface surface2 = this.getSurface();
            Intrinsics.checkNotNull((Object)surface2);
            this.setCanvas(surface2.getCanvas());
        } else {
            this.setRenderTarget(null);
            this.setSurface(null);
            this.setCanvas(null);
        }
    }

    @Override
    protected void flush() {
        super.flush();
        Surface surface = this.getSurface();
        if (surface != null) {
            surface.flushAndSubmit();
        }
        this.getMetalRedrawer().finishFrame();
    }

    @Override
    @NotNull
    public String rendererInfo() {
        return super.rendererInfo() + "Video card: " + this.getMetalRedrawer().getAdapterName() + "\nTotal VRAM: " + this.getMetalRedrawer().getAdapterMemorySize() / (long)1024 / (long)1024 + " MB\n";
    }
}

