/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.JvmContextHandler;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001cB$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\fH\u0082 J\b\u0010\r\u001a\u00020\u000bH\u0014J\b\u0010\u000e\u001a\u00020\u000bH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0011\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\fH\u0082 J!\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0082 J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\t\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/skiko/context/MetalContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "device", "Lorg/jetbrains/skiko/redrawer/MetalDevice;", "adapterInfo", "Lorg/jetbrains/skiko/context/MetalContextHandler$AdapterInfo;", "(Lorg/jetbrains/skiko/SkiaLayer;JLorg/jetbrains/skiko/context/MetalContextHandler$AdapterInfo;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "finishFrame", "", "", "flush", "initCanvas", "initContext", "", "makeContext", "Lorg/jetbrains/skia/DirectContext;", "makeMetalContext", "makeMetalRenderTarget", "width", "", "height", "makeRenderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "rendererInfo", "", "AdapterInfo", "skiko"})
@SourceDebugExtension(value={"SMAP\nMetalContextHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetalContextHandler.kt\norg/jetbrains/skiko/context/MetalContextHandler\n+ 2 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,95:1\n124#2,4:96\n159#2,4:100\n*S KotlinDebug\n*F\n+ 1 MetalContextHandler.kt\norg/jetbrains/skiko/context/MetalContextHandler\n*L\n27#1:96,4\n31#1:100,4\n*E\n"})
public final class MetalContextHandler
extends JvmContextHandler {
    private final long device;
    @Nullable
    private final AdapterInfo adapterInfo;

    private MetalContextHandler(SkiaLayer layer, long device2, AdapterInfo adapterInfo) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super(layer);
        this.device = device2;
        this.adapterInfo = adapterInfo;
    }

    public /* synthetic */ MetalContextHandler(SkiaLayer skiaLayer, long l, AdapterInfo adapterInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            adapterInfo = null;
        }
        this(skiaLayer, l, adapterInfo, null);
    }

    @Override
    protected boolean initContext() {
        try {
            if (this.getContext() == null) {
                this.setContext(this.makeContext());
                if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true")) {
                    Logger this_$iv = Logger.INSTANCE;
                    boolean $i$f$info = false;
                    if (this_$iv.getLoggerImpl().isInfoEnabled()) {
                        SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
                        boolean bl = false;
                        skikoLoggerInterface.info("Renderer info:\n " + this.rendererInfo());
                    }
                }
            }
        }
        catch (Exception e) {
            Logger this_$iv = Logger.INSTANCE;
            boolean $i$f$warn = false;
            if (this_$iv.getLoggerImpl().isWarnEnabled()) {
                Throwable throwable = e;
                SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
                boolean bl = false;
                String string = "Failed to create Skia Metal context!";
                skikoLoggerInterface.warn(throwable, string);
            }
            return false;
        }
        return true;
    }

    @Override
    protected void initCanvas() {
        this.disposeCanvas();
        float scale = this.getLayer().getContentScale();
        int width2 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getBackedLayer$skiko().getWidth() * scale)), (int)0);
        int height2 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getBackedLayer$skiko().getHeight() * scale)), (int)0);
        if (width2 > 0 && height2 > 0) {
            this.setRenderTarget(this.makeRenderTarget(width2, height2));
            DirectContext directContext = this.getContext();
            Intrinsics.checkNotNull((Object)directContext);
            BackendRenderTarget backendRenderTarget = this.getRenderTarget();
            Intrinsics.checkNotNull((Object)backendRenderTarget);
            Surface surface = Surface.Companion.makeFromBackendRenderTarget(directContext, backendRenderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null));
            if (surface == null) {
                throw new RenderException("Cannot create surface", null, 2, null);
            }
            this.setSurface(surface);
            Surface surface2 = this.getSurface();
            Intrinsics.checkNotNull((Object)surface2);
            this.setCanvas(surface2.getCanvas());
        } else {
            this.setRenderTarget(null);
            this.setSurface(null);
            this.setCanvas(null);
        }
    }

    @Override
    protected void flush() {
        super.flush();
        Surface surface = this.getSurface();
        if (surface != null) {
            surface.flushAndSubmit();
        }
        this.finishFrame();
    }

    @Override
    @NotNull
    public String rendererInfo() {
        return super.rendererInfo() + (this.adapterInfo != null ? "Video card: " + this.adapterInfo.getAdapterName() + "\nTotal VRAM: " + this.adapterInfo.getAdapterMemorySize() / (long)1024 / (long)1024 + " MB\n" : "");
    }

    private final BackendRenderTarget makeRenderTarget(int width2, int height2) {
        return new BackendRenderTarget(this.makeMetalRenderTarget(this.device, width2, height2));
    }

    private final DirectContext makeContext() {
        return new DirectContext(this.makeMetalContext(this.device));
    }

    private final void finishFrame() {
        this.finishFrame(this.device);
    }

    private final native long makeMetalContext(long var1);

    private final native long makeMetalRenderTarget(long var1, int var3, int var4);

    private final native void finishFrame(long var1);

    public /* synthetic */ MetalContextHandler(SkiaLayer layer, long device2, AdapterInfo adapterInfo, DefaultConstructorMarker $constructor_marker) {
        this(layer, device2, adapterInfo);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/skiko/context/MetalContextHandler$AdapterInfo;", "", "adapterName", "", "adapterMemorySize", "", "(Ljava/lang/String;J)V", "getAdapterMemorySize", "()J", "getAdapterName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "skiko"})
    public static final class AdapterInfo {
        @NotNull
        private final String adapterName;
        private final long adapterMemorySize;

        public AdapterInfo(@NotNull String adapterName, long adapterMemorySize) {
            Intrinsics.checkNotNullParameter((Object)adapterName, (String)"adapterName");
            this.adapterName = adapterName;
            this.adapterMemorySize = adapterMemorySize;
        }

        @NotNull
        public final String getAdapterName() {
            return this.adapterName;
        }

        public final long getAdapterMemorySize() {
            return this.adapterMemorySize;
        }

        @NotNull
        public final String component1() {
            return this.adapterName;
        }

        public final long component2() {
            return this.adapterMemorySize;
        }

        @NotNull
        public final AdapterInfo copy(@NotNull String adapterName, long adapterMemorySize) {
            Intrinsics.checkNotNullParameter((Object)adapterName, (String)"adapterName");
            return new AdapterInfo(adapterName, adapterMemorySize);
        }

        public static /* synthetic */ AdapterInfo copy$default(AdapterInfo adapterInfo, String string, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = adapterInfo.adapterName;
            }
            if ((n & 2) != 0) {
                l = adapterInfo.adapterMemorySize;
            }
            return adapterInfo.copy(string, l);
        }

        @NotNull
        public String toString() {
            return "AdapterInfo(adapterName=" + this.adapterName + ", adapterMemorySize=" + this.adapterMemorySize + ')';
        }

        public int hashCode() {
            int result = this.adapterName.hashCode();
            result = result * 31 + Long.hashCode(this.adapterMemorySize);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AdapterInfo)) {
                return false;
            }
            AdapterInfo adapterInfo = (AdapterInfo)other;
            if (!Intrinsics.areEqual((Object)this.adapterName, (Object)adapterInfo.adapterName)) {
                return false;
            }
            return this.adapterMemorySize == adapterInfo.adapterMemorySize;
        }
    }
}

