/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.MetalAdapter;
import org.jetbrains.skiko.MetalApiKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoView;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingOffscreenDrawer;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\fH\u0002J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u0017H\u0082 J!\u0010\u0018\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0082 J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J(\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0017H\u0014J\b\u0010 \u001a\u00020!H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/skiko/swing/MetalSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "skikoView", "Lorg/jetbrains/skiko/SkikoView;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoView;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "adapter", "Lorg/jetbrains/skiko/MetalAdapter;", "context", "Lorg/jetbrains/skia/DirectContext;", "swingOffscreenDrawer", "Lorg/jetbrains/skiko/swing/SwingOffscreenDrawer;", "dispose", "", "flush", "surface", "Lorg/jetbrains/skia/Surface;", "g", "Ljava/awt/Graphics2D;", "makeMetalContext", "", "makeMetalRenderTargetOffScreen", "width", "", "height", "makeRenderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "onRender", "nanoTime", "rendererInfo", "", "Companion", "skiko"})
public final class MetalSwingRedrawer
extends SwingRedrawerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SkikoView skikoView;
    @NotNull
    private final MetalAdapter adapter;
    @NotNull
    private final DirectContext context;
    @NotNull
    private final SwingOffscreenDrawer swingOffscreenDrawer;

    /*
     * WARNING - void declaration
     */
    public MetalSwingRedrawer(@NotNull SwingLayerProperties swingLayerProperties2, @NotNull SkikoView skikoView, @NotNull SkiaLayerAnalytics analytics) {
        void it;
        MetalAdapter metalAdapter;
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"swingLayerProperties");
        Intrinsics.checkNotNullParameter((Object)skikoView, (String)"skikoView");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        super(swingLayerProperties2, analytics, GraphicsApi.METAL);
        this.skikoView = skikoView;
        MetalAdapter metalAdapter2 = metalAdapter = MetalApiKt.chooseMetalAdapter(swingLayerProperties2.getAdapterPriority());
        MetalSwingRedrawer metalSwingRedrawer = this;
        boolean bl = false;
        this.onDeviceChosen(it.getName());
        metalSwingRedrawer.adapter = metalAdapter;
        this.context = this.makeMetalContext();
        this.onContextInit();
        this.swingOffscreenDrawer = new SwingOffscreenDrawer(swingLayerProperties2);
    }

    @Override
    public void dispose() {
        MetalApiKt.dispose(this.adapter);
        super.dispose();
    }

    @Override
    protected void onRender(@NotNull Graphics2D g, int width2, int height2, long nanoTime) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)new Function1<CloseScope, Unit>(this, width2, height2, nanoTime, g){
            final /* synthetic */ MetalSwingRedrawer this$0;
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;
            final /* synthetic */ long $nanoTime;
            final /* synthetic */ Graphics2D $g;
            {
                this.this$0 = $receiver;
                this.$width = $width;
                this.$height = $height;
                this.$nanoTime = $nanoTime;
                this.$g = $g;
                super(1);
            }

            public final void invoke(@NotNull CloseScope $this$autoCloseScope) {
                Surface surface;
                Intrinsics.checkNotNullParameter((Object)$this$autoCloseScope, (String)"$this$autoCloseScope");
                BackendRenderTarget renderTarget = (BackendRenderTarget)$this$autoCloseScope.autoClose((AutoCloseable)MetalSwingRedrawer.access$makeRenderTarget(this.this$0, this.$width, this.$height));
                Surface surface2 = Surface.Companion.makeFromBackendRenderTarget(MetalSwingRedrawer.access$getContext$p(this.this$0), renderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, PixelGeometry.UNKNOWN, 1, null));
                if (surface2 == null || (surface = (Surface)$this$autoCloseScope.autoClose((AutoCloseable)surface2)) == null) {
                    throw new RenderException("Cannot create surface", null, 2, null);
                }
                Surface surface3 = surface;
                Canvas canvas = surface3.getCanvas();
                canvas.clear(0);
                MetalSwingRedrawer.access$getSkikoView$p(this.this$0).onRender(canvas, this.$width, this.$height, this.$nanoTime);
                MetalSwingRedrawer.access$flush(this.this$0, surface3, this.$g);
            }
        }));
    }

    private final void flush(Surface surface, Graphics2D g) {
        surface.flushAndSubmit(true);
        int width2 = surface.getWidth();
        int height2 = surface.getHeight();
        Bitmap storage = new Bitmap();
        storage.setImageInfo(ImageInfo.Companion.makeN32Premul(width2, height2));
        storage.allocPixels();
        surface.readPixels(storage, 0, 0);
        byte[] bytes = storage.readPixels(storage.getImageInfo(), width2 * 4, 0, 0);
        if (bytes != null) {
            this.swingOffscreenDrawer.draw(g, bytes, width2, height2);
        }
    }

    @Override
    @NotNull
    protected String rendererInfo() {
        return super.rendererInfo() + "Video card: " + this.adapter.getName() + "\nTotal VRAM: " + this.adapter.getMemorySize() / (long)1024 / (long)1024 + " MB\n";
    }

    private final BackendRenderTarget makeRenderTarget(int width2, int height2) {
        return new BackendRenderTarget(this.makeMetalRenderTargetOffScreen(this.adapter.getPtr(), width2, height2));
    }

    private final DirectContext makeMetalContext() {
        return new DirectContext(this.makeMetalContext(this.adapter.getPtr()));
    }

    private final native long makeMetalContext(long var1);

    private final native long makeMetalRenderTargetOffScreen(long var1, int var3, int var4);

    public static final /* synthetic */ BackendRenderTarget access$makeRenderTarget(MetalSwingRedrawer $this, int width2, int height2) {
        return $this.makeRenderTarget(width2, height2);
    }

    public static final /* synthetic */ DirectContext access$getContext$p(MetalSwingRedrawer $this) {
        return $this.context;
    }

    public static final /* synthetic */ SkikoView access$getSkikoView$p(MetalSwingRedrawer $this) {
        return $this.skikoView;
    }

    public static final /* synthetic */ void access$flush(MetalSwingRedrawer $this, Surface surface, Graphics2D g) {
        $this.flush(surface, g);
    }

    static {
        Library.INSTANCE.load();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/skiko/swing/MetalSwingRedrawer$Companion;", "", "()V", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

