/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.awt.font;

import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0011\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0096\u0002J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/skiko/awt/font/FontFamilyKey;", "", "", "familyName", "(Ljava/lang/String;)V", "getFamilyName", "()Ljava/lang/String;", "identifier", "getIdentifier", "compareTo", "", "other", "equals", "", "", "hashCode", "toString", "Apple", "Awt", "skiko"})
public final class FontFamilyKey
implements Comparable<String> {
    @NotNull
    private final String familyName;
    @NotNull
    private final String identifier;

    public FontFamilyKey(@NotNull String familyName) {
        Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
        this.familyName = familyName;
        String string = this.familyName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.identifier = string;
    }

    @NotNull
    public final String getFamilyName() {
        return this.familyName;
    }

    @NotNull
    public final String getIdentifier() {
        return this.identifier;
    }

    @Override
    public int compareTo(@NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        String string = other.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return this.identifier.compareTo(string);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.skiko.awt.font.FontFamilyKey");
        FontFamilyKey cfr_ignored_0 = (FontFamilyKey)other;
        return Intrinsics.areEqual((Object)this.identifier, (Object)((FontFamilyKey)other).identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @NotNull
    public String toString() {
        return "FontFamilyKey(familyName='" + this.familyName + "')";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/skiko/awt/font/FontFamilyKey$Apple;", "", "()V", "AppleSystemUiFont", "Lorg/jetbrains/skiko/awt/font/FontFamilyKey;", "getAppleSystemUiFont", "()Lorg/jetbrains/skiko/awt/font/FontFamilyKey;", "SystemFont", "getSystemFont", "hiddenSystemFontNames", "", "getHiddenSystemFontNames", "()Ljava/util/Set;", "skiko"})
    public static final class Apple {
        @NotNull
        public static final Apple INSTANCE = new Apple();
        @NotNull
        private static final FontFamilyKey SystemFont = new FontFamilyKey("System Font");
        @NotNull
        private static final FontFamilyKey AppleSystemUiFont = new FontFamilyKey(".AppleSystemUIFont");
        @NotNull
        private static final Set<FontFamilyKey> hiddenSystemFontNames;

        private Apple() {
        }

        @NotNull
        public final FontFamilyKey getSystemFont() {
            return SystemFont;
        }

        @NotNull
        public final FontFamilyKey getAppleSystemUiFont() {
            return AppleSystemUiFont;
        }

        @NotNull
        public final Set<FontFamilyKey> getHiddenSystemFontNames() {
            return hiddenSystemFontNames;
        }

        static {
            Object[] objectArray = new FontFamilyKey[2];
            objectArray[0] = SystemFont;
            objectArray[1] = AppleSystemUiFont;
            hiddenSystemFontNames = SetsKt.setOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/skiko/awt/font/FontFamilyKey$Awt;", "", "()V", "Dialog", "Lorg/jetbrains/skiko/awt/font/FontFamilyKey;", "getDialog", "()Lorg/jetbrains/skiko/awt/font/FontFamilyKey;", "DialogInput", "getDialogInput", "Monospaced", "getMonospaced", "SansSerif", "getSansSerif", "Serif", "getSerif", "awtLogicalFonts", "", "getAwtLogicalFonts", "()Ljava/util/Set;", "skiko"})
    public static final class Awt {
        @NotNull
        public static final Awt INSTANCE = new Awt();
        @NotNull
        private static final FontFamilyKey Serif = new FontFamilyKey("Serif");
        @NotNull
        private static final FontFamilyKey SansSerif = new FontFamilyKey("SansSerif");
        @NotNull
        private static final FontFamilyKey Monospaced = new FontFamilyKey("Monospaced");
        @NotNull
        private static final FontFamilyKey Dialog = new FontFamilyKey("Dialog");
        @NotNull
        private static final FontFamilyKey DialogInput = new FontFamilyKey("DialogInput");
        @NotNull
        private static final Set<FontFamilyKey> awtLogicalFonts;

        private Awt() {
        }

        @NotNull
        public final FontFamilyKey getSerif() {
            return Serif;
        }

        @NotNull
        public final FontFamilyKey getSansSerif() {
            return SansSerif;
        }

        @NotNull
        public final FontFamilyKey getMonospaced() {
            return Monospaced;
        }

        @NotNull
        public final FontFamilyKey getDialog() {
            return Dialog;
        }

        @NotNull
        public final FontFamilyKey getDialogInput() {
            return DialogInput;
        }

        @NotNull
        public final Set<FontFamilyKey> getAwtLogicalFonts() {
            return awtLogicalFonts;
        }

        static {
            Object[] objectArray = new FontFamilyKey[5];
            objectArray[0] = Serif;
            objectArray[1] = SansSerif;
            objectArray[2] = Monospaced;
            objectArray[3] = Dialog;
            objectArray[4] = DialogInput;
            awtLogicalFonts = SetsKt.setOf((Object[])objectArray);
        }
    }
}

