/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skiko.JvmUtilsKt;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.SkikoLoggerInterface;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0006\u0010\b\u001a\u00020\u0007J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/skiko/InternalSunApiChecker;", "", "()V", "hasCheckedAccess", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isSunFontAccessible", "canAccessSunFontApi", "", "isSunFontApiAccessible", "logInstructions", "", "logJbrWarning", "skiko"})
@SourceDebugExtension(value={"SMAP\nInternalSunApiChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalSunApiChecker.kt\norg/jetbrains/skiko/InternalSunApiChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,73:1\n618#2,12:74\n118#3,4:86\n130#3,4:90\n136#3,4:94\n*S KotlinDebug\n*F\n+ 1 InternalSunApiChecker.kt\norg/jetbrains/skiko/InternalSunApiChecker\n*L\n29#1:74,12\n39#1:86,4\n47#1:90,4\n57#1:94,4\n*E\n"})
public final class InternalSunApiChecker {
    @NotNull
    public static final InternalSunApiChecker INSTANCE = new InternalSunApiChecker();
    @NotNull
    private static AtomicBoolean hasCheckedAccess = new AtomicBoolean(false);
    @NotNull
    private static AtomicBoolean isSunFontAccessible = new AtomicBoolean(false);

    private InternalSunApiChecker() {
    }

    public final boolean isSunFontApiAccessible() {
        boolean canAccess;
        if (hasCheckedAccess.get()) {
            return isSunFontAccessible.get();
        }
        if (!JvmUtilsKt.isRunningOnJetBrainsRuntime()) {
            this.logJbrWarning();
        }
        if (!(canAccess = this.canAccessSunFontApi())) {
            this.logInstructions();
        }
        isSunFontAccessible.set(canAccess);
        hasCheckedAccess.set(true);
        return canAccess;
    }

    private final boolean canAccessSunFontApi() {
        try {
            Module unnamedModule = ClassLoader.getSystemClassLoader().getUnnamedModule();
            Set<Module> set = ModuleLayer.boot().modules();
            Intrinsics.checkNotNullExpressionValue(set, (String)"modules(...)");
            Iterable $this$single$iv = set;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                Module it = (Module)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"java.desktop")) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Module desktopModule = single$iv;
            if (!unnamedModule.canRead(desktopModule)) {
                return false;
            }
            if (!desktopModule.isOpen("sun.font", unnamedModule)) {
                return false;
            }
            Class<?> fontManagerClass = Class.forName("sun.font.FontManagerFactory");
            fontManagerClass.getDeclaredMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Logger this_$iv = Logger.INSTANCE;
            boolean $i$f$debug = false;
            if (this_$iv.getLoggerImpl().isDebugEnabled()) {
                SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
                boolean bl = false;
                skikoLoggerInterface.debug("Sun Font APIs are accessible, advanced font features are available");
            }
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private final void logJbrWarning() {
        Logger this_$iv = Logger.INSTANCE;
        boolean $i$f$warn = false;
        if (this_$iv.getLoggerImpl().isWarnEnabled()) {
            SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
            boolean bl = false;
            skikoLoggerInterface.warn("The Java Runtime in use may not support all advanced Skiko features.\nIt is recommended that you run this app on the JetBrains Runtime for\nbest results.");
        }
    }

    private final void logInstructions() {
        Logger this_$iv = Logger.INSTANCE;
        boolean $i$f$error = false;
        if (this_$iv.getLoggerImpl().isErrorEnabled()) {
            SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
            boolean bl = false;
            skikoLoggerInterface.error("\n!!! WARNING !!!\nFor Skiko to run optimally, you should add the following argument\nto the command for this program:\n\n--add-opens java.desktop/sun.font=ALL-UNNAMED \n\nThis is required to be able to properly match the Skia fonts with\nthe AWT fonts and access private JDK APIs used for some advanced\nfeatures.");
        }
    }
}

