/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.awt.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.InternalSunApiChecker;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.ReflectionUtil;
import org.jetbrains.skiko.awt.font.AwtFontUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010#\u001a\n \u0006*\u0004\u0018\u00010\u00010\u0001H\u0002J\u0018\u0010$\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010%2\b\b\u0002\u0010&\u001a\u00020'J3\u0010(\u001a\u0004\u0018\u00010\b2\u0006\u0010)\u001a\u00020\u001e2\u001a\u0010*\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00040+\"\u0006\u0012\u0002\b\u00030\u0004H\u0002\u00a2\u0006\u0002\u0010,J!\u0010-\u001a\u0004\u0018\u00010\u001e2\u0006\u0010.\u001a\u00020\u001e2\b\b\u0002\u0010/\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b0J\f\u00101\u001a\u00020\u0001*\u00020\u0019H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\u0004\u0018\u00010\u001e*\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 \u00a8\u00062"}, d2={"Lorg/jetbrains/skiko/awt/font/AwtFontUtils;", "", "()V", "CFontClass", "Ljava/lang/Class;", "CompositeFontClass", "kotlin.jvm.PlatformType", "CompositeFont_getSlotFontMethod", "Ljava/lang/reflect/Method;", "FileFontClass", "FileFont_getPublicFileNameMethod", "Font2DClass", "Font2DHandle_font2DField", "Ljava/lang/reflect/Field;", "Font2D_getFamilyNameMethod", "Font2D_getTypographicFamilyNameMethod", "Font2D_handleField", "FontManagerClass", "FontManagerFactoryClass", "FontManagerFactory_getInstanceMethod", "FontManager_findFont2DMethod", "LOGICAL_FALLBACK", "", "font2DHandlesCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/awt/Font;", "isAbleToResolveFontProperties", "", "()Z", "fontFamilyName", "", "getFontFamilyName", "(Ljava/awt/Font;)Ljava/lang/String;", "fontFileName", "getFontFileName", "awtFontManager", "fontFamilyNamesOrNull", "Ljava/util/SortedSet;", "graphicsEnvironment", "Ljava/awt/GraphicsEnvironment;", "getFont2DMethodOrNull", "methodName", "parameters", "", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "resolvePhysicalFontNameOrNull", "fontName", "style", "resolvePhysicalFontNameOrNull$skiko", "obtainFont2D", "skiko"})
@SourceDebugExtension(value={"SMAP\nAwtFontUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwtFontUtils.kt\norg/jetbrains/skiko/awt/font/AwtFontUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n*L\n1#1,228:1\n1#2:229\n1#2:236\n11065#3:230\n11400#3,3:231\n72#4,2:234\n*S KotlinDebug\n*F\n+ 1 AwtFontUtils.kt\norg/jetbrains/skiko/awt/font/AwtFontUtils\n*L\n208#1:236\n156#1:230\n156#1:231,3\n208#1:234,2\n*E\n"})
public final class AwtFontUtils {
    @NotNull
    public static final AwtFontUtils INSTANCE = new AwtFontUtils();
    private static final Class<?> FontManagerFactoryClass;
    private static final Class<?> FontManagerClass;
    private static final Class<?> Font2DClass;
    private static final Class<?> FileFontClass;
    private static final Class<?> CompositeFontClass;
    @Nullable
    private static final Class<?> CFontClass;
    @Nullable
    private static final Method FontManagerFactory_getInstanceMethod;
    @Nullable
    private static final Method FontManager_findFont2DMethod;
    @Nullable
    private static final Method Font2D_getTypographicFamilyNameMethod;
    @Nullable
    private static final Method Font2D_getFamilyNameMethod;
    @Nullable
    private static final Field Font2D_handleField;
    @Nullable
    private static final Field Font2DHandle_font2DField;
    @Nullable
    private static final Method FileFont_getPublicFileNameMethod;
    @Nullable
    private static final Method CompositeFont_getSlotFontMethod;
    private static final int LOGICAL_FALLBACK = 2;
    @NotNull
    private static final ConcurrentHashMap<Font, Object> font2DHandlesCache;

    private AwtFontUtils() {
    }

    public final boolean isAbleToResolveFontProperties() {
        return Font2D_getTypographicFamilyNameMethod != null;
    }

    @Nullable
    public final String resolvePhysicalFontNameOrNull$skiko(@NotNull String fontName, int style) {
        String string;
        Intrinsics.checkNotNullParameter((Object)fontName, (String)"fontName");
        if (!this.isAbleToResolveFontProperties()) {
            return null;
        }
        Object fontManager = this.awtFontManager();
        Method method = FontManager_findFont2DMethod;
        if (method == null) {
            boolean bl = false;
            String string2 = "FontManager#findFont2DMethod() is not available";
            throw new IllegalStateException(string2.toString());
        }
        Object[] objectArray = new Object[]{fontName, style, 2};
        Object font2D = method.invoke(fontManager, objectArray);
        if (CompositeFontClass.isInstance(font2D)) {
            Object object;
            Object object2;
            Object[] objectArray2;
            Method method2 = CompositeFont_getSlotFontMethod;
            if (method2 != null) {
                objectArray2 = new Object[]{0};
                object2 = method2.invoke(font2D, objectArray2);
            } else {
                object2 = null;
            }
            Object physicalFontObject = object2;
            Method method3 = Font2D_getFamilyNameMethod;
            if (method3 != null) {
                objectArray2 = new Object[]{Locale.getDefault()};
                object = method3.invoke(physicalFontObject, objectArray2);
            } else {
                object = null;
            }
            string = (String)object;
        } else {
            Class<?> clazz = CFontClass;
            boolean bl = clazz != null ? clazz.isInstance(font2D) : false;
            if (bl) {
                String nativeFontName = ReflectionUtil.INSTANCE.getFieldValueOrNull(CFontClass, font2D, String.class, "nativeFontName");
                string = this.getFontFamilyName(new Font(nativeFontName, 0, 10));
            } else {
                throw new IllegalStateException(("Unsupported Font2D subclass: " + font2D.getClass().getName()).toString());
            }
        }
        return string;
    }

    public static /* synthetic */ String resolvePhysicalFontNameOrNull$skiko$default(AwtFontUtils awtFontUtils, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return awtFontUtils.resolvePhysicalFontNameOrNull$skiko(string, n);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SortedSet<String> fontFamilyNamesOrNull(@NotNull GraphicsEnvironment graphicsEnvironment) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)graphicsEnvironment, (String)"graphicsEnvironment");
        if (!this.isAbleToResolveFontProperties()) {
            return null;
        }
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        Intrinsics.checkNotNullExpressionValue((Object)fontArray, (String)"getAllFonts(...)");
        Object[] $this$map$iv = fontArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void font;
            Font font2 = (Font)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)font);
            String string = INSTANCE.getFontFamilyName((Font)font);
            Intrinsics.checkNotNull((Object)string);
            collection.add(string);
        }
        return CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
    }

    public static /* synthetic */ SortedSet fontFamilyNamesOrNull$default(AwtFontUtils awtFontUtils, GraphicsEnvironment graphicsEnvironment, int n, Object object) {
        if ((n & 1) != 0) {
            GraphicsEnvironment graphicsEnvironment2 = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Intrinsics.checkNotNullExpressionValue((Object)graphicsEnvironment2, (String)"getLocalGraphicsEnvironment(...)");
            graphicsEnvironment = graphicsEnvironment2;
        }
        return awtFontUtils.fontFamilyNamesOrNull(graphicsEnvironment);
    }

    @Nullable
    public final String getFontFamilyName(@NotNull Font $this$fontFamilyName) {
        Intrinsics.checkNotNullParameter((Object)$this$fontFamilyName, (String)"<this>");
        if (!this.isAbleToResolveFontProperties()) {
            return null;
        }
        Object font2D = this.obtainFont2D($this$fontFamilyName);
        Method method = Font2D_getTypographicFamilyNameMethod;
        if (method == null) {
            boolean bl = false;
            String string = "Font2D#getTypographicFamilyName() is not available";
            throw new IllegalStateException(string.toString());
        }
        Object object = method.invoke(font2D, new Object[0]);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    @Nullable
    public final String getFontFileName(@NotNull Font $this$fontFileName) {
        Intrinsics.checkNotNullParameter((Object)$this$fontFileName, (String)"<this>");
        if (!this.isAbleToResolveFontProperties()) {
            return null;
        }
        Object font2D = this.obtainFont2D($this$fontFileName);
        if (!FileFontClass.isInstance(font2D)) {
            return null;
        }
        Method method = FileFont_getPublicFileNameMethod;
        if (method == null) {
            boolean bl = false;
            String string = "FileFont#getPublicFileName() is not available";
            throw new IllegalStateException(string.toString());
        }
        Object object = method.invoke(font2D, new Object[0]);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    private final Object obtainFont2D(Font $this$obtainFont2D) {
        ConcurrentMap $this$getOrPut$iv = font2DHandlesCache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get($this$obtainFont2D);
        if (object == null) {
            boolean bl = false;
            Object fontManager = INSTANCE.awtFontManager();
            Method method = FontManager_findFont2DMethod;
            if (method == null) {
                boolean $i$a$-checkNotNull-AwtFontUtils$obtainFont2D$handle$1$font2D$22 = false;
                String $i$a$-checkNotNull-AwtFontUtils$obtainFont2D$handle$1$font2D$22 = "FontManager#findFont2DMethod() is not available";
                throw new IllegalStateException($i$a$-checkNotNull-AwtFontUtils$obtainFont2D$handle$1$font2D$22.toString());
            }
            Object[] objectArray = new Object[]{$this$obtainFont2D.getName(), $this$obtainFont2D.getStyle(), 2};
            Object font2D = method.invoke(fontManager, objectArray);
            Field field = Font2D_handleField;
            if (field == null) {
                boolean bl2 = false;
                String string = "Font2D#handle is not available";
                throw new IllegalStateException(string.toString());
            }
            Object default$iv = field.get(font2D);
            boolean bl3 = false;
            object = $this$getOrPut$iv.putIfAbsent($this$obtainFont2D, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Object handle = object;
        Field field = Font2DHandle_font2DField;
        if (field == null) {
            boolean bl = false;
            String string = "Font2DHandle#font2D is not available";
            throw new IllegalStateException(string.toString());
        }
        Object object2 = field.get(handle);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        return object2;
    }

    private final Object awtFontManager() {
        Method method = FontManagerFactory_getInstanceMethod;
        if (method == null) {
            boolean bl = false;
            String string = "FontManagerFactory#getInstanceMethod() not available";
            throw new IllegalStateException(string.toString());
        }
        return method.invoke(null, new Object[0]);
    }

    private final Method getFont2DMethodOrNull(String methodName, Class<?> ... parameters) {
        Class<?> clazz = Font2DClass;
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"Font2DClass");
        return ReflectionUtil.INSTANCE.getDeclaredMethodOrNull(clazz, methodName, Arrays.copyOf(parameters, parameters.length));
    }

    private static final boolean Font2D_handleField$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean Font2DHandle_font2DField$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        InternalSunApiChecker.INSTANCE.isSunFontApiAccessible();
        FontManagerFactoryClass = Class.forName("sun.font.FontManagerFactory");
        FontManagerClass = Class.forName("sun.font.FontManager");
        Font2DClass = Class.forName("sun.font.Font2D");
        FileFontClass = Class.forName("sun.font.FileFont");
        CompositeFontClass = Class.forName("sun.font.CompositeFont");
        CFontClass = OsArch_jvmKt.getHostOs().isMacOS() ? Class.forName("sun.font.CFont") : null;
        Class<?> clazz = FontManagerFactoryClass;
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"FontManagerFactoryClass");
        FontManagerFactory_getInstanceMethod = ReflectionUtil.INSTANCE.getDeclaredMethodOrNull(clazz, "getInstance", new Class[0]);
        Class<?> clazz2 = FontManagerClass;
        Intrinsics.checkNotNullExpressionValue(clazz2, (String)"FontManagerClass");
        Class[] classArray = new Class[3];
        classArray[0] = String.class;
        Intrinsics.checkNotNull(Integer.TYPE);
        Intrinsics.checkNotNull(Integer.TYPE);
        FontManager_findFont2DMethod = ReflectionUtil.INSTANCE.getDeclaredMethodOrNull(clazz2, "findFont2D", classArray);
        Font2D_getTypographicFamilyNameMethod = INSTANCE.getFont2DMethodOrNull("getTypographicFamilyName", new Class[0]);
        classArray = new Class[]{Locale.class};
        Font2D_getFamilyNameMethod = INSTANCE.getFont2DMethodOrNull("getFamilyName", classArray);
        Class<?> clazz3 = Font2DClass;
        Intrinsics.checkNotNullExpressionValue(clazz3, (String)"Font2DClass");
        Font2D_handleField = ReflectionUtil.INSTANCE.findFieldInHierarchy(clazz3, arg_0 -> AwtFontUtils.Font2D_handleField$lambda$0(Font2D_handleField.1.INSTANCE, arg_0));
        Class<?> clazz4 = Class.forName("sun.font.Font2DHandle");
        Intrinsics.checkNotNullExpressionValue(clazz4, (String)"forName(...)");
        Font2DHandle_font2DField = ReflectionUtil.INSTANCE.findFieldInHierarchy(clazz4, arg_0 -> AwtFontUtils.Font2DHandle_font2DField$lambda$1(Font2DHandle_font2DField.1.INSTANCE, arg_0));
        Class<?> clazz5 = FileFontClass;
        Intrinsics.checkNotNullExpressionValue(clazz5, (String)"FileFontClass");
        FileFont_getPublicFileNameMethod = ReflectionUtil.INSTANCE.getDeclaredMethodOrNull(clazz5, "getPublicFileNameMethod", new Class[0]);
        Class<?> clazz6 = CompositeFontClass;
        Intrinsics.checkNotNullExpressionValue(clazz6, (String)"CompositeFontClass");
        classArray = new Class[1];
        Intrinsics.checkNotNull(Integer.TYPE);
        CompositeFont_getSlotFontMethod = ReflectionUtil.INSTANCE.getDeclaredMethodOrNull(clazz6, "getSlotFont", classArray);
        font2DHandlesCache = new ConcurrentHashMap();
    }
}

