/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.Arch;
import org.jetbrains.skiko.FrameBuffering;
import org.jetbrains.skiko.GpuPriority;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u00106\u001a\u0002032\b\u00107\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010<\u001a\u0004\u0018\u00010\u00052\u0006\u0010=\u001a\u00020\u0005H\u0002J\u0017\u0010>\u001a\u00020)2\b\u0010?\u001a\u0004\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\b@J\b\u0010A\u001a\u00020)H\u0002J\u001b\u0010B\u001a\b\u0012\u0004\u0012\u00020)0C2\u0006\u0010D\u001a\u00020)H\u0000\u00a2\u0006\u0002\bER(\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058F@@X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\u0017\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u0011\u0010\u0019\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R\u0011\u0010\u001b\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010R\u0011\u0010\u001d\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0010R\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0010R\u0013\u0010%\u001a\u0004\u0018\u00010 8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0010R\u0011\u00102\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0018\u00108\u001a\n :*\u0004\u0018\u00010909X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010;\u00a8\u0006F"}, d2={"Lorg/jetbrains/skiko/SkikoProperties;", "", "<init>", "()V", "value", "", "libraryPath", "getLibraryPath", "()Ljava/lang/String;", "setLibraryPath$skiko", "(Ljava/lang/String;)V", "dataPath", "getDataPath", "vsyncEnabled", "", "getVsyncEnabled", "()Z", "frameBuffering", "Lorg/jetbrains/skiko/FrameBuffering;", "getFrameBuffering", "()Lorg/jetbrains/skiko/FrameBuffering;", "windowsWaitForVsyncOnRedrawImmediately", "getWindowsWaitForVsyncOnRedrawImmediately", "linuxWaitForVsyncOnRedrawImmediately", "getLinuxWaitForVsyncOnRedrawImmediately", "renderingAngleEnabled", "getRenderingAngleEnabled", "vsyncFramelimitFallbackEnabled", "getVsyncFramelimitFallbackEnabled", "fpsEnabled", "getFpsEnabled", "fpsPeriodSeconds", "", "getFpsPeriodSeconds", "()D", "fpsLongFramesShow", "getFpsLongFramesShow", "fpsLongFramesMillis", "getFpsLongFramesMillis", "()Ljava/lang/Double;", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "gpuPriority", "Lorg/jetbrains/skiko/GpuPriority;", "getGpuPriority", "()Lorg/jetbrains/skiko/GpuPriority;", "macOsOpenGLEnabled", "getMacOsOpenGLEnabled", "gpuResourceCacheLimit", "", "getGpuResourceCacheLimit", "()J", "parseSize", "size", "properties", "Ljava/util/Properties;", "kotlin.jvm.PlatformType", "Ljava/util/Properties;", "getProperty", "key", "parseRenderApi", "text", "parseRenderApi$skiko", "bestRenderApiForCurrentOS", "fallbackRenderApiQueue", "", "initialApi", "fallbackRenderApiQueue$skiko", "skiko"})
@SourceDebugExtension(value={"SMAP\nSkikoProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkikoProperties.kt\norg/jetbrains/skiko/SkikoProperties\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1#2:195\n*E\n"})
public final class SkikoProperties {
    @NotNull
    public static final SkikoProperties INSTANCE;
    private static final Properties properties;

    private SkikoProperties() {
    }

    @Nullable
    public final String getLibraryPath() {
        return this.getProperty("skiko.library.path");
    }

    public final void setLibraryPath$skiko(@Nullable String value) {
        String string = value != null ? System.setProperty("skiko.library.path", value) : System.clearProperty("skiko.library.path");
    }

    @NotNull
    public final String getDataPath() {
        String string = this.getProperty("skiko.data.path");
        if (string == null) {
            string = this.getProperty("user.home") + "/.skiko/";
        }
        return string;
    }

    public final boolean getVsyncEnabled() {
        String string = this.getProperty("skiko.vsync.enabled");
        return string != null ? Boolean.parseBoolean(string) : true;
    }

    @NotNull
    public final FrameBuffering getFrameBuffering() {
        String string = this.getProperty("skiko.buffering");
        return Intrinsics.areEqual((Object)string, (Object)"DOUBLE") ? FrameBuffering.DOUBLE : (Intrinsics.areEqual((Object)string, (Object)"TRIPLE") ? FrameBuffering.TRIPLE : FrameBuffering.DEFAULT);
    }

    public final boolean getWindowsWaitForVsyncOnRedrawImmediately() {
        String string = this.getProperty("skiko.rendering.windows.waitForFrameVsyncOnRedrawImmediately");
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    public final boolean getLinuxWaitForVsyncOnRedrawImmediately() {
        String string = this.getProperty("skiko.rendering.linux.waitForFrameVsyncOnRedrawImmediately");
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    public final boolean getRenderingAngleEnabled() {
        String string = this.getProperty("skiko.rendering.angle.enabled");
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    public final boolean getVsyncFramelimitFallbackEnabled() {
        String string = this.getProperty("skiko.vsync.framelimit.fallback.enabled");
        return string != null ? Boolean.parseBoolean(string) : true;
    }

    public final boolean getFpsEnabled() {
        String string = this.getProperty("skiko.fps.enabled");
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    public final double getFpsPeriodSeconds() {
        String string = this.getProperty("skiko.fps.periodSeconds");
        return string != null ? Double.parseDouble(string) : 2.0;
    }

    public final boolean getFpsLongFramesShow() {
        String string = this.getProperty("skiko.fps.longFrames.show");
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    @Nullable
    public final Double getFpsLongFramesMillis() {
        String string = this.getProperty("skiko.fps.longFrames.millis");
        return string != null ? Double.valueOf(Double.parseDouble(string)) : null;
    }

    @NotNull
    public final GraphicsApi getRenderApi() {
        String environment = System.getenv("SKIKO_RENDER_API");
        String property = this.getProperty("skiko.renderApi");
        String string = environment;
        if (string == null) {
            string = property;
        }
        return this.parseRenderApi$skiko(string);
    }

    @NotNull
    public final GpuPriority getGpuPriority() {
        Object object;
        block5: {
            block4: {
                String value;
                String string = this.getProperty("skiko.gpu.priority");
                if (string == null && (string = this.getProperty("skiko.metal.gpu.priority")) == null) {
                    string = this.getProperty("skiko.directx.gpu.priority");
                }
                if ((object = (value = string)) == null) break block4;
                String string2 = object;
                GpuPriority.Companion companion = GpuPriority.Companion;
                String p0 = string2;
                boolean bl = false;
                GpuPriority gpuPriority = companion.parseOrNull(p0);
                object = gpuPriority;
                if (gpuPriority != null) break block5;
            }
            object = GpuPriority.Auto;
        }
        return object;
    }

    public final boolean getMacOsOpenGLEnabled() {
        String string = this.getProperty("skiko.macos.opengl.enabled");
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    public final long getGpuResourceCacheLimit() {
        return this.parseSize(this.getProperty("skiko.gpu.resourceCacheLimit"));
    }

    private final long parseSize(String size) {
        String string;
        long multiplier;
        if (size == null) {
            return -1L;
        }
        String string2 = size.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        String size2 = string2;
        long l = StringsKt.endsWith$default((String)size2, (String)"K", (boolean)false, (int)2, null) ? 1024L : (StringsKt.endsWith$default((String)size2, (String)"M", (boolean)false, (int)2, null) ? 0x100000L : (multiplier = StringsKt.endsWith$default((String)size2, (String)"G", (boolean)false, (int)2, null) ? 0x40000000L : 1L));
        if (multiplier != 1L) {
            String string3 = size2.substring(0, size2.length() - 1);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = size2;
        }
        String numericPart = string;
        Long l2 = StringsKt.toLongOrNull((String)numericPart);
        if (l2 == null) {
            throw new IllegalArgumentException("Invalid size format: " + size2);
        }
        return l2 * multiplier;
    }

    private final String getProperty(String key) {
        return properties.getProperty(key);
    }

    @NotNull
    public final GraphicsApi parseRenderApi$skiko(@Nullable String text) {
        block31: {
            String string = text;
            if (string == null) break block31;
            int n = -1;
            switch (string.hashCode()) {
                case -1019861004: {
                    if (string.equals("SOFTWARE_FAST")) {
                        n = 1;
                    }
                    break;
                }
                case -907020006: {
                    if (string.equals("SOFTWARE_COMPAT")) {
                        n = 2;
                    }
                    break;
                }
                case -1957249873: {
                    if (string.equals("OPENGL")) {
                        n = 3;
                    }
                    break;
                }
                case 1028669466: {
                    if (string.equals("DIRECT3D")) {
                        n = 4;
                    }
                    break;
                }
                case 73249511: {
                    if (string.equals("METAL")) {
                        n = 5;
                    }
                    break;
                }
                case 62423219: {
                    if (string.equals("ANGLE")) {
                        n = 6;
                    }
                    break;
                }
                case 2101957031: {
                    if (string.equals("SOFTWARE")) {
                        n = 7;
                    }
                    break;
                }
                case 1644349757: {
                    if (string.equals("DIRECT_SOFTWARE")) {
                        n = 1;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    return GraphicsApi.SOFTWARE_COMPAT;
                }
                case 1: {
                    return GraphicsApi.SOFTWARE_FAST;
                }
                case 7: {
                    return OsArch_jvmKt.getHostOs() == OS.MacOS ? GraphicsApi.SOFTWARE_COMPAT : GraphicsApi.SOFTWARE_FAST;
                }
                case 3: {
                    if (OsArch_jvmKt.getHostOs() == OS.Windows && OsArch_jvmKt.getHostArch() == Arch.Arm64) {
                        throw new Exception((Object)((Object)OsArch_jvmKt.getHostOs()) + '-' + (Object)((Object)OsArch_jvmKt.getHostArch()) + " does not support OpenGL rendering API.");
                    }
                    return GraphicsApi.OPENGL;
                }
                case 6: {
                    if (OsArch_jvmKt.getHostOs() != OS.Windows) {
                        throw new Exception((Object)((Object)OsArch_jvmKt.getHostOs()) + " does not support ANGLE rendering API.");
                    }
                    return GraphicsApi.ANGLE;
                }
                case 4: {
                    if (OsArch_jvmKt.getHostOs() != OS.Windows) {
                        throw new Exception((Object)((Object)OsArch_jvmKt.getHostOs()) + " does not support DirectX rendering API.");
                    }
                    return GraphicsApi.DIRECT3D;
                }
                case 5: {
                    if (OsArch_jvmKt.getHostOs() != OS.MacOS) {
                        throw new Exception((Object)((Object)OsArch_jvmKt.getHostOs()) + " does not support Metal rendering API.");
                    }
                    return GraphicsApi.METAL;
                }
            }
        }
        return this.bestRenderApiForCurrentOS();
    }

    private final GraphicsApi bestRenderApiForCurrentOS() {
        GraphicsApi graphicsApi;
        switch (WhenMappings.$EnumSwitchMapping$0[OsArch_jvmKt.getHostOs().ordinal()]) {
            case 1: {
                graphicsApi = GraphicsApi.METAL;
                break;
            }
            case 2: {
                graphicsApi = GraphicsApi.OPENGL;
                break;
            }
            case 3: {
                if (this.getRenderingAngleEnabled()) {
                    graphicsApi = GraphicsApi.ANGLE;
                    break;
                }
                graphicsApi = GraphicsApi.DIRECT3D;
                break;
            }
            case 4: {
                graphicsApi = GraphicsApi.OPENGL;
                break;
            }
            default: {
                graphicsApi = GraphicsApi.UNKNOWN;
            }
        }
        return graphicsApi;
    }

    @NotNull
    public final List<GraphicsApi> fallbackRenderApiQueue$skiko(@NotNull GraphicsApi initialApi) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)((Object)initialApi), (String)"initialApi");
        switch (WhenMappings.$EnumSwitchMapping$0[OsArch_jvmKt.getHostOs().ordinal()]) {
            case 2: {
                GraphicsApi[] graphicsApiArray = new GraphicsApi[]{GraphicsApi.OPENGL, GraphicsApi.SOFTWARE_FAST, GraphicsApi.SOFTWARE_COMPAT};
                list2 = CollectionsKt.listOf((Object[])graphicsApiArray);
                break;
            }
            case 1: {
                GraphicsApi[] graphicsApiArray = new GraphicsApi[]{GraphicsApi.METAL, GraphicsApi.SOFTWARE_COMPAT};
                list2 = CollectionsKt.listOf((Object[])graphicsApiArray);
                break;
            }
            case 3: {
                GraphicsApi[] graphicsApiArray;
                if (WhenMappings.$EnumSwitchMapping$1[OsArch_jvmKt.getHostArch().ordinal()] == 1) {
                    graphicsApiArray = new GraphicsApi[]{GraphicsApi.ANGLE, GraphicsApi.DIRECT3D, GraphicsApi.SOFTWARE_FAST, GraphicsApi.SOFTWARE_COMPAT};
                    list2 = CollectionsKt.listOf((Object[])graphicsApiArray);
                    break;
                }
                graphicsApiArray = new GraphicsApi[]{GraphicsApi.ANGLE, GraphicsApi.DIRECT3D, GraphicsApi.OPENGL, GraphicsApi.SOFTWARE_FAST, GraphicsApi.SOFTWARE_COMPAT};
                list2 = CollectionsKt.listOf((Object[])graphicsApiArray);
                break;
            }
            case 4: {
                return CollectionsKt.listOf((Object)((Object)GraphicsApi.OPENGL));
            }
            default: {
                return CollectionsKt.listOf((Object)((Object)GraphicsApi.UNKNOWN));
            }
        }
        List fallbackApis = list2;
        int indexOfInitialApi = fallbackApis.indexOf((Object)initialApi);
        if (!(indexOfInitialApi >= 0)) {
            boolean bl = false;
            String string = (Object)((Object)OsArch_jvmKt.getHostOs()) + " does not support " + (Object)((Object)initialApi) + " rendering API.";
            throw new IllegalArgumentException(string.toString());
        }
        fallbackApis = CollectionsKt.drop((Iterable)fallbackApis, (int)(indexOfInitialApi + 1));
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((Object)initialApi)), (Iterable)fallbackApis);
    }

    static {
        Properties properties;
        SkikoProperties $this$properties_u24lambda_u241 = INSTANCE = new SkikoProperties();
        boolean bl = false;
        String string = System.getProperty("skiko.resource.properties.enabled");
        boolean resourcePropertiesEnabled = string != null ? Boolean.parseBoolean(string) : false;
        InputStream resources = resourcePropertiesEnabled ? SkikoProperties.class.getClassLoader().getResourceAsStream("skiko.properties") : null;
        Properties systemProps = System.getProperties();
        if (resources == null) {
            properties = systemProps;
        } else {
            Properties properties2;
            Properties $this$properties_u24lambda_u241_u24lambda_u240 = properties2 = new Properties(systemProps);
            boolean bl2 = false;
            $this$properties_u24lambda_u241_u24lambda_u240.load(resources);
            properties = properties2;
        }
        SkikoProperties.properties = properties;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.MacOS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Android.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Arch.values().length];
            try {
                nArray[Arch.Arm64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

