/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import java.lang.ref.Reference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skia.impl.NativeKt;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.context.ContextBasedContextHandler;
import org.jetbrains.skiko.redrawer.Direct3DRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u001aH\u0014J\b\u0010\u001c\u001a\u00020\u001aH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0019\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0082 R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/skiko/context/Direct3DContextHandler;", "Lorg/jetbrains/skiko/context/ContextBasedContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "<init>", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "bufferCount", "", "surfaces", "", "Lorg/jetbrains/skia/Surface;", "[Lorg/jetbrains/skia/Surface;", "isSurfacesNull", "", "directXRedrawer", "Lorg/jetbrains/skiko/redrawer/Direct3DRedrawer;", "getDirectXRedrawer", "()Lorg/jetbrains/skiko/redrawer/Direct3DRedrawer;", "makeContext", "Lorg/jetbrains/skia/DirectContext;", "currentWidth", "currentHeight", "isSizeChanged", "width", "height", "initCanvas", "", "flush", "disposeCanvas", "rendererInfo", "", "context", "", "surface", "skiko"})
@SourceDebugExtension(value={"SMAP\nDirect3DContextHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Direct3DContextHandler.kt\norg/jetbrains/skiko/context/Direct3DContextHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,96:1\n12308#2,2:97\n*S KotlinDebug\n*F\n+ 1 Direct3DContextHandler.kt\norg/jetbrains/skiko/context/Direct3DContextHandler\n*L\n15#1:97,2\n*E\n"})
public final class Direct3DContextHandler
extends ContextBasedContextHandler {
    private final int bufferCount;
    @NotNull
    private Surface[] surfaces;
    private int currentWidth;
    private int currentHeight;

    public Direct3DContextHandler(@NotNull SkiaLayer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super(layer, "Direct3D");
        this.bufferCount = 2;
        this.surfaces = new Surface[this.bufferCount];
    }

    private final boolean isSurfacesNull() {
        boolean bl;
        block1: {
            Surface[] $this$all$iv = this.surfaces;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                Surface element$iv;
                Surface it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (it == null) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private final Direct3DRedrawer getDirectXRedrawer() {
        Redrawer redrawer = this.getLayer().getRedrawer$skiko();
        Intrinsics.checkNotNull((Object)redrawer);
        return (Direct3DRedrawer)redrawer;
    }

    @Override
    @NotNull
    protected DirectContext makeContext() {
        return this.getDirectXRedrawer().makeContext();
    }

    private final boolean isSizeChanged(int width, int height) {
        if (width != this.currentWidth || height != this.currentHeight) {
            this.currentWidth = width;
            this.currentHeight = height;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initCanvas() {
        int height;
        DirectContext directContext = this.getContext();
        if (directContext == null) {
            return;
        }
        DirectContext context = directContext;
        float scale = this.getLayer().getContentScale();
        int width = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)1);
        if (this.isSizeChanged(width, height = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)1)) || this.isSurfacesNull()) {
            this.disposeCanvas();
            context.flush();
            boolean justInitialized = this.getDirectXRedrawer().changeSize(width, height);
            try {
                SurfaceProps surfaceProps = new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null);
                int n = this.bufferCount;
                for (int bufferIndex = 0; bufferIndex < n; ++bufferIndex) {
                    this.surfaces[bufferIndex] = this.getDirectXRedrawer().makeSurface(NativeKt.getPtr(context), width, height, surfaceProps, bufferIndex);
                }
            }
            finally {
                Reference.reachabilityFence(context);
            }
            if (justInitialized) {
                this.getDirectXRedrawer().initFence();
            }
        }
        this.setSurface(this.surfaces[this.getDirectXRedrawer().getBufferIndex()]);
        Surface surface = this.getSurface();
        Intrinsics.checkNotNull((Object)surface);
        this.setCanvas(surface.getCanvas());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flush() {
        DirectContext directContext = this.getContext();
        if (directContext == null) {
            return;
        }
        DirectContext context = directContext;
        Surface surface = this.getSurface();
        if (surface == null) {
            return;
        }
        Surface surface2 = surface;
        try {
            this.flush(NativeKt.getPtr(context), NativeKt.getPtr(surface2));
        }
        finally {
            Reference.reachabilityFence(context);
            Reference.reachabilityFence(surface2);
        }
    }

    @Override
    protected void disposeCanvas() {
        int n = this.bufferCount;
        for (int bufferIndex = 0; bufferIndex < n; ++bufferIndex) {
            Surface surface = this.surfaces[bufferIndex];
            if (surface == null) continue;
            surface.close();
        }
    }

    @Override
    @NotNull
    public String rendererInfo() {
        return super.rendererInfo() + "Video card: " + this.getDirectXRedrawer().getAdapterName() + "\nTotal VRAM: " + this.getDirectXRedrawer().getAdapterMemorySize() / (long)1024 / (long)1024 + " MB\n";
    }

    private final native void flush(long var1, long var3);
}

