/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skiko.ClipRectangle;
import org.jetbrains.skiko.ExperimentalSkikoApi;
import org.jetbrains.skiko.GpuPriority;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.NativeAccessibleFocusHelper;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.SkiaLayer_awtKt;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.redrawer.RedrawerManager;
import org.jetbrains.skiko.swing.SkiaSwingLayer;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingRedrawer;
import org.jetbrains.skiko.swing.SwingRedrawerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0002$'\b\u0017\u0018\u0000 62\u00020\u0001:\u00016B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010)\u001a\u00020*H\u0016J\u0006\u0010+\u001a\u00020*J\n\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0012\u0010.\u001a\u00020*2\b\b\u0002\u0010/\u001a\u00020\u0013H\u0002J\u0010\u00100\u001a\u00020*2\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020*H\u0016J\u0010\u00104\u001a\u00020*2\b\u00105\u001a\u0004\u0018\u00010\tR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0017\u0010\u0018R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0010\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010%R\u0010\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010(\u00a8\u00067"}, d2={"Lorg/jetbrains/skiko/swing/SkiaSwingLayer;", "Ljavax/swing/JPanel;", "renderDelegate", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "externalAccessibleFactory", "Lkotlin/Function1;", "Ljava/awt/Component;", "Ljavax/accessibility/Accessible;", "properties", "Lorg/jetbrains/skiko/SkiaLayerProperties;", "(Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/skiko/SkiaLayerProperties;)V", "clipComponents", "", "Lorg/jetbrains/skiko/ClipRectangle;", "getClipComponents", "()Ljava/util/List;", "isDisposed", "", "isInitialized", "nativeAccessibleFocusHelper", "Lorg/jetbrains/skiko/NativeAccessibleFocusHelper;", "getNativeAccessibleFocusHelper$annotations", "()V", "redrawer", "Lorg/jetbrains/skiko/swing/SwingRedrawer;", "getRedrawer", "()Lorg/jetbrains/skiko/swing/SwingRedrawer;", "redrawerManager", "Lorg/jetbrains/skiko/redrawer/RedrawerManager;", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "renderDelegateWithClipping", "org/jetbrains/skiko/swing/SkiaSwingLayer$renderDelegateWithClipping$1", "Lorg/jetbrains/skiko/swing/SkiaSwingLayer$renderDelegateWithClipping$1;", "swingLayerProperties", "org/jetbrains/skiko/swing/SkiaSwingLayer$swingLayerProperties$1", "Lorg/jetbrains/skiko/swing/SkiaSwingLayer$swingLayerProperties$1;", "addNotify", "", "dispose", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "init", "recreation", "paint", "g", "Ljava/awt/Graphics;", "removeNotify", "requestNativeFocusOnAccessible", "accessible", "Companion", "skiko"})
@ExperimentalSkikoApi
@SourceDebugExtension(value={"SMAP\nSkiaSwingLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkiaSwingLayer.kt\norg/jetbrains/skiko/swing/SkiaSwingLayer\n+ 2 Logging.kt\norg/jetbrains/skiko/Logger\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n118#2,4:142\n118#2,4:146\n159#2,4:151\n1#3:150\n*S KotlinDebug\n*F\n+ 1 SkiaSwingLayer.kt\norg/jetbrains/skiko/swing/SkiaSwingLayer\n*L\n88#1:142,4\n94#1:146,4\n120#1:151,4\n*E\n"})
public class SkiaSwingLayer
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SkiaLayerProperties properties;
    private boolean isInitialized;
    private volatile boolean isDisposed;
    @NotNull
    private final renderDelegateWithClipping.1 renderDelegateWithClipping;
    @NotNull
    private final swingLayerProperties.1 swingLayerProperties;
    @NotNull
    private final RedrawerManager<SwingRedrawer> redrawerManager;
    @NotNull
    private final NativeAccessibleFocusHelper nativeAccessibleFocusHelper;

    public SkiaSwingLayer(@NotNull SkikoRenderDelegate renderDelegate, @NotNull SkiaLayerAnalytics analytics, @Nullable Function1<? super Component, ? extends Accessible> externalAccessibleFactory, @NotNull SkiaLayerProperties properties) {
        Intrinsics.checkNotNullParameter((Object)renderDelegate, (String)"renderDelegate");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.properties = properties;
        this.renderDelegateWithClipping = new SkikoRenderDelegate(renderDelegate, this){
            private final /* synthetic */ SkikoRenderDelegate $$delegate_0;
            final /* synthetic */ SkikoRenderDelegate $renderDelegate;
            final /* synthetic */ SkiaSwingLayer this$0;
            {
                this.$renderDelegate = $renderDelegate;
                this.this$0 = $receiver;
                this.$$delegate_0 = $renderDelegate;
            }

            public void onRender(@NotNull Canvas canvas, int width2, int height2, long nanoTime) {
                Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
                float scale = (float)this.this$0.getGraphicsConfiguration().getDefaultTransform().getScaleX();
                for (ClipRectangle component : this.this$0.getClipComponents()) {
                    SkiaLayer_awtKt.clipRectBy(canvas, component, scale);
                }
                this.$renderDelegate.onRender(canvas, width2, height2, nanoTime);
            }
        };
        this.swingLayerProperties = new SwingLayerProperties(this){
            final /* synthetic */ SkiaSwingLayer this$0;
            {
                this.this$0 = $receiver;
            }

            public int getWidth() {
                return this.this$0.getWidth();
            }

            public int getHeight() {
                return this.this$0.getHeight();
            }

            @NotNull
            public GraphicsConfiguration getGraphicsConfiguration() {
                GraphicsConfiguration graphicsConfiguration = this.this$0.getGraphicsConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"getGraphicsConfiguration(...)");
                return graphicsConfiguration;
            }

            @NotNull
            public GpuPriority getAdapterPriority() {
                return SkiaSwingLayer.access$getProperties$p(this.this$0).getAdapterPriority();
            }
        };
        this.redrawerManager = new RedrawerManager(this.properties.getRenderApi(), (Function2)new Function2<GraphicsApi, SwingRedrawer, SwingRedrawer>(this, analytics){
            final /* synthetic */ SkiaSwingLayer this$0;
            final /* synthetic */ SkiaLayerAnalytics $analytics;
            {
                this.this$0 = $receiver;
                this.$analytics = $analytics;
                super(2);
            }

            @NotNull
            public final SwingRedrawer invoke(@NotNull GraphicsApi renderApi, @Nullable SwingRedrawer oldRedrawer) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)renderApi), (String)"renderApi");
                    SwingRedrawer swingRedrawer = oldRedrawer;
                    if (swingRedrawer == null) break block0;
                    swingRedrawer.dispose();
                }
                return SwingRedrawerKt.createSwingRedrawer(SkiaSwingLayer.access$getSwingLayerProperties$p(this.this$0), SkiaSwingLayer.access$getRenderDelegateWithClipping$p(this.this$0), renderApi, this.$analytics);
            }
        }, null, 4, null);
        this.setOpaque(false);
        this.setLayout(null);
        Function1<? super Component, ? extends Accessible> function1 = externalAccessibleFactory;
        this.nativeAccessibleFocusHelper = new NativeAccessibleFocusHelper(this, function1 != null ? (Accessible)function1.invoke((Object)this) : null);
    }

    public /* synthetic */ SkiaSwingLayer(SkikoRenderDelegate skikoRenderDelegate, SkiaLayerAnalytics skiaLayerAnalytics, Function1 function1, SkiaLayerProperties skiaLayerProperties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            skiaLayerAnalytics = SkiaLayerAnalytics.Companion.getEmpty();
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        if ((n & 8) != 0) {
            skiaLayerProperties = new SkiaLayerProperties(false, false, null, null, null, 31, null);
        }
        this(skikoRenderDelegate, skiaLayerAnalytics, (Function1<? super Component, ? extends Accessible>)function1, skiaLayerProperties);
    }

    @NotNull
    public final List<ClipRectangle> getClipComponents() {
        return new ArrayList();
    }

    private final SwingRedrawer getRedrawer() {
        return this.redrawerManager.getRedrawer();
    }

    @NotNull
    public final GraphicsApi getRenderApi() {
        return this.redrawerManager.getRenderApi();
    }

    @Override
    public void removeNotify() {
        Logger this_$iv = Logger.INSTANCE;
        boolean $i$f$debug = false;
        if (this_$iv.getLoggerImpl().isDebugEnabled()) {
            SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
            boolean bl = false;
            skikoLoggerInterface.debug("SkiaSwingLayer.awt#removeNotify " + this);
        }
        this.dispose();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        Logger this_$iv = Logger.INSTANCE;
        boolean $i$f$debug = false;
        if (this_$iv.getLoggerImpl().isDebugEnabled()) {
            SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
            boolean bl = false;
            skikoLoggerInterface.debug("SkiaSwingLayer.awt#addNotify " + this);
        }
        super.addNotify();
        this.init(this.isInitialized);
    }

    private final void init(boolean recreation) {
        this.isDisposed = false;
        this.redrawerManager.findNextWorkingRenderApi(recreation);
        this.isInitialized = true;
    }

    static /* synthetic */ void init$default(SkiaSwingLayer skiaSwingLayer, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: init");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        skiaSwingLayer.init(bl);
    }

    public final void dispose() {
        if (!SwingUtilities.isEventDispatchThread()) {
            boolean bl = false;
            String string = "Method should be called from AWT event dispatch thread";
            throw new IllegalStateException(string.toString());
        }
        if (this.isInitialized && !this.isDisposed) {
            SwingRedrawer swingRedrawer = this.getRedrawer();
            if (swingRedrawer != null) {
                swingRedrawer.dispose();
            }
            this.redrawerManager.dispose();
            this.isDisposed = true;
        }
    }

    @Override
    public void paint(@NotNull Graphics g) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            try {
                SwingRedrawer swingRedrawer = this.getRedrawer();
                if (swingRedrawer != null) {
                    swingRedrawer.redraw((Graphics2D)g);
                }
            }
            catch (RenderException e) {
                if (this.isDisposed) break block4;
                Logger this_$iv = Logger.INSTANCE;
                boolean $i$f$warn = false;
                if (this_$iv.getLoggerImpl().isWarnEnabled()) {
                    Throwable throwable = e;
                    SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
                    boolean bl = false;
                    String string = "Exception in draw scope";
                    skikoLoggerInterface.warn(throwable, string);
                }
                RedrawerManager.findNextWorkingRenderApi$default(this.redrawerManager, false, 1, null);
                this.repaint();
            }
        }
    }

    private static /* synthetic */ void getNativeAccessibleFocusHelper$annotations() {
    }

    @Override
    @Nullable
    public AccessibleContext getAccessibleContext() {
        AccessibleContext accessibleContext = this.nativeAccessibleFocusHelper.getAccessibleContext();
        if (accessibleContext == null) {
            accessibleContext = super.getAccessibleContext();
        }
        return accessibleContext;
    }

    public final void requestNativeFocusOnAccessible(@Nullable Accessible accessible) {
        this.nativeAccessibleFocusHelper.requestNativeFocusOnAccessible(accessible);
    }

    public static final /* synthetic */ SkiaLayerProperties access$getProperties$p(SkiaSwingLayer $this) {
        return $this.properties;
    }

    public static final /* synthetic */ swingLayerProperties.1 access$getSwingLayerProperties$p(SkiaSwingLayer $this) {
        return $this.swingLayerProperties;
    }

    public static final /* synthetic */ renderDelegateWithClipping.1 access$getRenderDelegateWithClipping$p(SkiaSwingLayer $this) {
        return $this.renderDelegateWithClipping;
    }

    static {
        Library.INSTANCE.load();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/skiko/swing/SkiaSwingLayer$Companion;", "", "()V", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

