/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.im.InputMethodRequests;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ClipMode;
import org.jetbrains.skia.Picture;
import org.jetbrains.skia.PictureRecorder;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.impl.Managed;
import org.jetbrains.skiko.ClipRectangle;
import org.jetbrains.skiko.Convertors_jvmKt;
import org.jetbrains.skiko.FPSCounter;
import org.jetbrains.skiko.FrameWatcher;
import org.jetbrains.skiko.FullscreenAdapter;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.HardwareLayer;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.PictureHolder;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.RenderFactory;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.SkiaLayer_jvmKt;
import org.jetbrains.skiko.SkikoProperties;
import org.jetbrains.skiko.SkikoView;
import org.jetbrains.skiko.redrawer.Redrawer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0090\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0016\u0018\u0000 \u00a9\u00012\u00020\u0001:\u0004\u00a9\u0001\u00aa\u0001B=\b\u0016\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB1\b\u0000\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\\\u001a\u00020V2\u0006\u0010]\u001a\u00020^H\u0016J\u0010\u0010_\u001a\u00020V2\u0006\u0010]\u001a\u00020`H\u0016J\u0010\u0010a\u001a\u00020V2\u0006\u0010]\u001a\u00020bH\u0016J\u0010\u0010c\u001a\u00020V2\u0006\u0010]\u001a\u00020dH\u0016J\u0010\u0010e\u001a\u00020V2\u0006\u0010]\u001a\u00020fH\u0016J\b\u0010g\u001a\u00020VH\u0016J\u000e\u0010h\u001a\u00020V2\u0006\u0010i\u001a\u00020NJ\u000e\u0010j\u001a\u00020V2\u0006\u0010k\u001a\u00020lJ\u000e\u0010j\u001a\u00020V2\u0006\u0010m\u001a\u00020;J\b\u0010n\u001a\u00020VH\u0002J\u0006\u0010o\u001a\u00020VJ\b\u0010p\u001a\u00020VH\u0016J\u0015\u0010q\u001a\u00020V2\u0006\u0010\u0016\u001a\u00020rH\u0000\u00a2\u0006\u0002\bsJ\u0010\u0010t\u001a\u00020V2\u0006\u0010u\u001a\u00020\u0007H\u0016J\b\u0010v\u001a\u00020VH\u0002J\u0013\u0010w\u001a\b\u0012\u0004\u0012\u00020^0xH\u0016\u00a2\u0006\u0002\u0010yJ\u001f\u0010z\u001a\u00020V2\f\u0010{\u001a\b\u0012\u0004\u0012\u00020V0|H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b}J\u0012\u0010~\u001a\u00020V2\b\b\u0002\u0010\u007f\u001a\u00020\u0007H\u0002J\t\u0010\u0080\u0001\u001a\u00020\u0007H\u0016J3\u0010\u0081\u0001\u001a\u0005\u0018\u0001H\u0082\u0001\"\t\b\u0000\u0010\u0082\u0001*\u00020;2\u0014\u0010\u0083\u0001\u001a\u000f\u0012\u0004\u0012\u000209\u0012\u0005\u0012\u0003H\u0082\u00010\u0003H\u0002\u00a2\u0006\u0003\u0010\u0084\u0001J\u0007\u0010\u0085\u0001\u001a\u00020VJ\u0012\u0010\u0086\u0001\u001a\u00020V2\u0007\u0010\u0087\u0001\u001a\u00020UH\u0002J%\u0010\u0088\u0001\u001a\u00020V2\u0007\u0010\u0087\u0001\u001a\u00020U2\u0013\u0010\u0089\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020V0\u0003J\u0013\u0010\u008a\u0001\u001a\u00020V2\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001H\u0016J\u0015\u0010\u008d\u0001\u001a\u00020V2\n\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008f\u0001H\u0014J\u0011\u0010\u0090\u0001\u001a\u00020V2\u0006\u0010]\u001a\u00020^H\u0016J\u0011\u0010\u0091\u0001\u001a\u00020V2\u0006\u0010]\u001a\u00020`H\u0016J\u0011\u0010\u0092\u0001\u001a\u00020V2\u0006\u0010]\u001a\u00020bH\u0016J\u0011\u0010\u0093\u0001\u001a\u00020V2\u0006\u0010]\u001a\u00020dH\u0016J\u0011\u0010\u0094\u0001\u001a\u00020V2\u0006\u0010]\u001a\u00020fH\u0016J\t\u0010\u0095\u0001\u001a\u00020VH\u0016J\t\u0010\u0096\u0001\u001a\u00020VH\u0016J\u0015\u0010\u0096\u0001\u001a\u00020V2\n\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0098\u0001H\u0016J\u0013\u0010\u0099\u0001\u001a\u00030\u009a\u00012\u0007\u0010,\u001a\u00030\u009a\u0001H\u0002J\n\u0010\u009b\u0001\u001a\u0005\u0018\u00010\u009c\u0001J1\u0010\u009d\u0001\u001a\u00020V2\b\u0010\u009e\u0001\u001a\u00030\u009a\u00012\b\u0010\u009f\u0001\u001a\u00030\u009a\u00012\b\u0010\u00a0\u0001\u001a\u00030\u009a\u00012\b\u0010\u00a1\u0001\u001a\u00030\u009a\u0001H\u0016J\u0012\u0010\u00a2\u0001\u001a\u00020V2\u0007\u0010\u00a3\u0001\u001a\u00020\u0007H\u0016J\u0018\u0010\u00a4\u0001\u001a\u00020V2\u0007\u0010\u00a5\u0001\u001a\u00020 H\u0000\u00a2\u0006\u0003\b\u00a6\u0001J\u0016\u0010\u00a7\u0001\u001a\u00020V*\u00020r2\u0007\u0010\u00a8\u0001\u001a\u00020\u001cH\u0002R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\u0004\u0018\u00010)X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b*\u0010+R$\u0010-\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u000e\u00102\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u0004\u0018\u00010=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010>\u001a\u0004\u0018\u00010?X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR$\u0010\t\u001a\u00020\n2\u0006\u0010,\u001a\u00020\n8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u000e\u0010H\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010I\u001a\u00020J8F\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u001c\u0010M\u001a\u0004\u0018\u00010NX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR,\u0010S\u001a \u0012\u0004\u0012\u00020U\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020V0\u00030\u001b0TX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010W\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bX\u0010/\"\u0004\bY\u00101R\u0011\u0010Z\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b[\u0010\"\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u00ab\u0001"}, d2={"Lorg/jetbrains/skiko/SkiaLayer;", "Ljavax/swing/JPanel;", "externalAccessibleFactory", "Lkotlin/Function1;", "Ljava/awt/Component;", "Ljavax/accessibility/Accessible;", "isVsyncEnabled", "", "isVsyncFramelimitFallbackEnabled", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "(Lkotlin/jvm/functions/Function1;ZZLorg/jetbrains/skiko/GraphicsApi;)V", "properties", "Lorg/jetbrains/skiko/SkiaLayerProperties;", "renderFactory", "Lorg/jetbrains/skiko/RenderFactory;", "(Lkotlin/jvm/functions/Function1;Lorg/jetbrains/skiko/SkiaLayerProperties;Lorg/jetbrains/skiko/RenderFactory;)V", "_transparency", "backedLayer", "Lorg/jetbrains/skiko/HardwareLayer;", "getBackedLayer$skiko", "()Lorg/jetbrains/skiko/HardwareLayer;", "canvas", "Ljava/awt/Canvas;", "getCanvas", "()Ljava/awt/Canvas;", "clipComponents", "", "Lorg/jetbrains/skiko/ClipRectangle;", "getClipComponents", "()Ljava/util/List;", "contentHandle", "", "getContentHandle", "()J", "contentScale", "", "getContentScale", "()F", "fallbackRenderApiQueue", "fpsCounter", "Lorg/jetbrains/skiko/FPSCounter;", "getFpsCounter$annotations", "()V", "value", "fullscreen", "getFullscreen", "()Z", "setFullscreen", "(Z)V", "fullscreenAdapter", "Lorg/jetbrains/skiko/FullscreenAdapter;", "isDisposed", "isInited", "isRendering", "isShowingCached", "picture", "Lorg/jetbrains/skiko/PictureHolder;", "pictureLock", "", "pictureRecorder", "Lorg/jetbrains/skia/PictureRecorder;", "redrawer", "Lorg/jetbrains/skiko/redrawer/Redrawer;", "getRedrawer$skiko", "()Lorg/jetbrains/skiko/redrawer/Redrawer;", "setRedrawer$skiko", "(Lorg/jetbrains/skiko/redrawer/Redrawer;)V", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "setRenderApi", "(Lorg/jetbrains/skiko/GraphicsApi;)V", "renderApi_", "renderInfo", "", "getRenderInfo", "()Ljava/lang/String;", "skikoView", "Lorg/jetbrains/skiko/SkikoView;", "getSkikoView", "()Lorg/jetbrains/skiko/SkikoView;", "setSkikoView", "(Lorg/jetbrains/skiko/SkikoView;)V", "stateHandlers", "", "Lorg/jetbrains/skiko/SkiaLayer$PropertyKind;", "", "transparency", "getTransparency", "setTransparency", "windowHandle", "getWindowHandle", "addInputMethodListener", "l", "Ljava/awt/event/InputMethodListener;", "addKeyListener", "Ljava/awt/event/KeyListener;", "addMouseListener", "Ljava/awt/event/MouseListener;", "addMouseMotionListener", "Ljava/awt/event/MouseMotionListener;", "addMouseWheelListener", "Ljava/awt/event/MouseWheelListener;", "addNotify", "addView", "view", "attachTo", "jComponent", "Ljavax/swing/JComponent;", "container", "checkShowing", "detach", "dispose", "draw", "Lorg/jetbrains/skia/Canvas;", "draw$skiko", "enableInputMethods", "enable", "findNextWorkingRenderApi", "getInputMethodListeners", "", "()[Ljava/awt/event/InputMethodListener;", "inDrawScope", "body", "Lkotlin/Function0;", "inDrawScope$skiko", "init", "recreation", "isShowing", "lockPicture", "T", "action", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "needRedraw", "notifyChange", "kind", "onStateChanged", "handler", "paint", "g", "Ljava/awt/Graphics;", "processInputMethodEvent", "e", "Ljava/awt/event/InputMethodEvent;", "removeInputMethodListener", "removeKeyListener", "removeMouseListener", "removeMouseMotionListener", "removeMouseWheelListener", "removeNotify", "requestFocus", "cause", "Ljava/awt/event/FocusEvent$Cause;", "roundSize", "", "screenshot", "Lorg/jetbrains/skia/Bitmap;", "setBounds", "x", "y", "width", "height", "setFocusTraversalKeysEnabled", "focusTraversalKeysEnabled", "update", "nanoTime", "update$skiko", "clipRectBy", "rectangle", "Companion", "PropertyKind", "skiko"})
public class SkiaLayer
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SkiaLayerProperties properties;
    @NotNull
    private final RenderFactory renderFactory;
    private boolean _transparency;
    @NotNull
    private final HardwareLayer backedLayer;
    @NotNull
    private FullscreenAdapter fullscreenAdapter;
    private boolean isInited;
    private boolean isRendering;
    private boolean isShowingCached;
    @Nullable
    private SkikoView skikoView;
    @NotNull
    private final List<ClipRectangle> clipComponents;
    private volatile boolean isDisposed;
    @Nullable
    private Redrawer redrawer;
    @NotNull
    private final List<GraphicsApi> fallbackRenderApiQueue;
    @NotNull
    private GraphicsApi renderApi_;
    @Nullable
    private volatile PictureHolder picture;
    @Nullable
    private PictureRecorder pictureRecorder;
    @NotNull
    private final Object pictureLock;
    @NotNull
    private final Map<PropertyKind, List<Function1<SkiaLayer, Unit>>> stateHandlers;
    @Nullable
    private final FPSCounter fpsCounter;

    public SkiaLayer(final @Nullable Function1<? super Component, ? extends Accessible> externalAccessibleFactory, @NotNull SkiaLayerProperties properties, @NotNull RenderFactory renderFactory) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)renderFactory, (String)"renderFactory");
        this.properties = properties;
        this.renderFactory = renderFactory;
        this.setOpaque(false);
        this.setLayout(null);
        this.backedLayer = new HardwareLayer(){

            @Override
            public void paint(@NotNull Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Redrawer redrawer = this.getRedrawer$skiko();
                if (redrawer != null) {
                    redrawer.needRedraw();
                }
            }

            @Override
            @Nullable
            public InputMethodRequests getInputMethodRequests() {
                return this.getInputMethodRequests();
            }
        };
        this.add(this.backedLayer);
        this.backedLayer.addHierarchyListener(arg_0 -> SkiaLayer._init_$lambda-0(this, arg_0));
        this.fullscreenAdapter = new FullscreenAdapter(this.backedLayer);
        boolean bl = false;
        this.clipComponents = new ArrayList();
        this.fallbackRenderApiQueue = CollectionsKt.toMutableList((Collection)SkikoProperties.INSTANCE.fallbackRenderApiQueue(this.properties.getRenderApi()));
        this.renderApi_ = this.fallbackRenderApiQueue.get(0);
        this.pictureLock = new Object();
        bl = false;
        this.stateHandlers = new LinkedHashMap();
        this.fpsCounter = SkiaLayer_jvmKt.defaultFPSCounter(this);
    }

    public /* synthetic */ SkiaLayer(Function1 function1, SkiaLayerProperties skiaLayerProperties, RenderFactory renderFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        if ((n & 4) != 0) {
            renderFactory = RenderFactory.Companion.getDefault();
        }
        this((Function1<? super Component, ? extends Accessible>)function1, skiaLayerProperties, renderFactory);
    }

    public final boolean getTransparency() {
        return this._transparency;
    }

    public final void setTransparency(boolean value) {
        this._transparency = value;
        if (!value) {
            this.setBackground(UIManager.getColor("Panel.background"));
        } else {
            this.setBackground(new Color(0, 0, 0, 0));
        }
    }

    @NotNull
    public final HardwareLayer getBackedLayer$skiko() {
        return this.backedLayer;
    }

    public SkiaLayer(@Nullable Function1<? super Component, ? extends Accessible> externalAccessibleFactory, boolean isVsyncEnabled, boolean isVsyncFramelimitFallbackEnabled, @NotNull GraphicsApi renderApi) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderApi), (String)"renderApi");
        this(externalAccessibleFactory, new SkiaLayerProperties(isVsyncEnabled, isVsyncFramelimitFallbackEnabled, renderApi), RenderFactory.Companion.getDefault());
    }

    public /* synthetic */ SkiaLayer(Function1 function1, boolean bl, boolean bl2, GraphicsApi graphicsApi, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        if ((n & 2) != 0) {
            bl = SkikoProperties.INSTANCE.getVsyncEnabled();
        }
        if ((n & 4) != 0) {
            bl2 = SkikoProperties.INSTANCE.getVsyncFramelimitFallbackEnabled();
        }
        if ((n & 8) != 0) {
            graphicsApi = SkikoProperties.INSTANCE.getRenderApi();
        }
        this((Function1<? super Component, ? extends Accessible>)function1, bl, bl2, graphicsApi);
    }

    @NotNull
    public final java.awt.Canvas getCanvas() {
        return this.backedLayer;
    }

    @Override
    public void removeNotify() {
        Component component = SwingUtilities.getRoot(this);
        if (component == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Window");
        }
        Window window = (Window)component;
        window.removeComponentListener(this.fullscreenAdapter);
        this.dispose();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Component component = SwingUtilities.getRoot(this);
        if (component == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Window");
        }
        Window window = (Window)component;
        window.addComponentListener(this.fullscreenAdapter);
        this.backedLayer.defineContentScale();
        this.checkShowing();
        this.init(this.isInited);
    }

    public final void detach() {
        this.dispose();
    }

    private final void checkShowing() {
        this.isShowingCached = super.isShowing();
        if (this.isShowing()) {
            this.repaint();
        }
    }

    @Override
    public boolean isShowing() {
        return this.isShowingCached;
    }

    public final float getContentScale() {
        return this.backedLayer.getContentScale();
    }

    public final long getContentHandle() {
        return this.backedLayer.getContentHandle();
    }

    public final long getWindowHandle() {
        return this.backedLayer.getWindowHandle();
    }

    public final boolean getFullscreen() {
        return this.fullscreenAdapter.getFullscreen();
    }

    public final void setFullscreen(boolean value) {
        this.fullscreenAdapter.setFullscreen(value);
    }

    @Nullable
    public final SkikoView getSkikoView() {
        return this.skikoView;
    }

    public final void setSkikoView(@Nullable SkikoView skikoView) {
        this.skikoView = skikoView;
    }

    public final void attachTo(@NotNull Object container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.attachTo((JComponent)container);
    }

    public final void attachTo(@NotNull JComponent jComponent) {
        Intrinsics.checkNotNullParameter((Object)jComponent, (String)"jComponent");
        jComponent.add(this);
    }

    public final void addView(@NotNull SkikoView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.skikoView = view;
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ SkiaLayer this$0;
            {
                this.this$0 = $receiver;
            }

            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SkikoView skikoView = this.this$0.getSkikoView();
                if (skikoView != null) {
                    skikoView.onPointerEvent(Convertors_jvmKt.toSkikoEvent(e));
                }
            }

            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SkikoView skikoView = this.this$0.getSkikoView();
                if (skikoView != null) {
                    skikoView.onPointerEvent(Convertors_jvmKt.toSkikoEvent(e));
                }
            }

            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SkikoView skikoView = this.this$0.getSkikoView();
                if (skikoView != null) {
                    skikoView.onPointerEvent(Convertors_jvmKt.toSkikoEvent(e));
                }
            }

            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SkikoView skikoView = this.this$0.getSkikoView();
                if (skikoView != null) {
                    skikoView.onPointerEvent(Convertors_jvmKt.toSkikoEvent(e));
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(this){
            final /* synthetic */ SkiaLayer this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SkikoView skikoView = this.this$0.getSkikoView();
                if (skikoView != null) {
                    skikoView.onPointerEvent(Convertors_jvmKt.toSkikoEvent(e));
                }
            }

            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SkikoView skikoView = this.this$0.getSkikoView();
                if (skikoView != null) {
                    skikoView.onPointerEvent(Convertors_jvmKt.toSkikoEvent(e));
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(this){
            final /* synthetic */ SkiaLayer this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SkikoView skikoView = this.this$0.getSkikoView();
                if (skikoView != null) {
                    skikoView.onPointerEvent(Convertors_jvmKt.toSkikoEvent(e));
                }
            }
        });
        this.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ SkiaLayer this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SkikoView skikoView = this.this$0.getSkikoView();
                if (skikoView != null) {
                    skikoView.onKeyboardEvent(Convertors_jvmKt.toSkikoEvent(e));
                }
            }

            public void keyReleased(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SkikoView skikoView = this.this$0.getSkikoView();
                if (skikoView != null) {
                    skikoView.onKeyboardEvent(Convertors_jvmKt.toSkikoEvent(e));
                }
            }

            public void keyTyped(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SkikoView skikoView = this.this$0.getSkikoView();
                if (skikoView != null) {
                    skikoView.onKeyboardEvent(Convertors_jvmKt.toSkikoEvent(e));
                }
            }
        });
        this.addInputMethodListener(new InputMethodListener(this){
            final /* synthetic */ SkiaLayer this$0;
            {
                this.this$0 = $receiver;
            }

            public void caretPositionChanged(@NotNull InputMethodEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SkikoView skikoView = this.this$0.getSkikoView();
                if (skikoView != null) {
                    skikoView.onInputEvent(Convertors_jvmKt.toSkikoEvent(e));
                }
            }

            public void inputMethodTextChanged(@NotNull InputMethodEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SkikoView skikoView = this.this$0.getSkikoView();
                if (skikoView != null) {
                    skikoView.onInputEvent(Convertors_jvmKt.toSkikoEvent(e));
                }
            }
        });
    }

    @NotNull
    public final List<ClipRectangle> getClipComponents() {
        return this.clipComponents;
    }

    @Nullable
    public final Redrawer getRedrawer$skiko() {
        return this.redrawer;
    }

    public final void setRedrawer$skiko(@Nullable Redrawer redrawer) {
        this.redrawer = redrawer;
    }

    @NotNull
    public final GraphicsApi getRenderApi() {
        return this.renderApi_;
    }

    private final void setRenderApi(GraphicsApi value) {
        this.renderApi_ = value;
        this.notifyChange(PropertyKind.Renderer);
    }

    @NotNull
    public final String getRenderInfo() {
        String string;
        if (this.redrawer == null) {
            string = "SkiaLayer isn't initialized yet";
        } else {
            Redrawer redrawer = this.redrawer;
            Intrinsics.checkNotNull((Object)redrawer);
            string = redrawer.getRenderInfo();
        }
        return string;
    }

    private final void findNextWorkingRenderApi() {
        Object object;
        boolean thrown = false;
        do {
            thrown = false;
            try {
                this.setRenderApi(this.fallbackRenderApiQueue.remove(0));
                object = this.redrawer;
                if (object != null) {
                    object.dispose();
                }
                this.redrawer = this.renderFactory.createRedrawer(this, this.getRenderApi(), this.properties);
                object = this.redrawer;
                if (object != null) {
                    object.syncSize();
                }
            }
            catch (RenderException e) {
                String string = e.getMessage();
                boolean bl = false;
                System.out.println((Object)string);
                thrown = true;
            }
            if (!thrown) break;
            object = this.fallbackRenderApiQueue;
            boolean bl = false;
        } while (!object.isEmpty());
        if (thrown && this.fallbackRenderApiQueue.isEmpty()) {
            throw new RenderException("Cannot fallback to any render API", null, 2, null);
        }
    }

    private final void init(boolean recreation) {
        this.isDisposed = false;
        this.backedLayer.init();
        this.pictureRecorder = new PictureRecorder();
        if (recreation) {
            this.fallbackRenderApiQueue.add(0, this.getRenderApi());
        }
        this.findNextWorkingRenderApi();
        this.isInited = true;
    }

    static /* synthetic */ void init$default(SkiaLayer skiaLayer, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: init");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        skiaLayer.init(bl);
    }

    public final void onStateChanged(@NotNull PropertyKind kind, @NotNull Function1<? super SkiaLayer, Unit> handler) {
        List list;
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Map<PropertyKind, List<Function1<SkiaLayer, Unit>>> $this$getOrPut$iv = this.stateHandlers;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get((Object)kind);
        if (value$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(kind, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        Collection collection = list;
        boolean bl = false;
        collection.add(handler);
    }

    private final void notifyChange(PropertyKind kind) {
        List<Function1<SkiaLayer, Unit>> list = this.stateHandlers.get((Object)kind);
        if (list != null) {
            List<Function1<SkiaLayer, Unit>> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<Function1<SkiaLayer, Unit>> handlers = list2;
            boolean bl3 = false;
            Iterable $this$forEach$iv = handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl4 = false;
                it.invoke((Object)this);
            }
        }
    }

    public void dispose() {
        boolean bl = SwingUtilities.isEventDispatchThread();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Method should be called from AWT event dispatch thread";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (this.isInited && !this.isDisposed) {
            Picture picture;
            Object object = this.redrawer;
            if (object != null) {
                object.dispose();
            }
            this.redrawer = null;
            object = this.picture;
            if (object != null && (picture = ((PictureHolder)object).getInstance()) != null) {
                picture.close();
            }
            this.picture = null;
            object = this.pictureRecorder;
            if (object != null) {
                ((Managed)object).close();
            }
            this.pictureRecorder = null;
            this.backedLayer.dispose();
            this.isDisposed = true;
        }
    }

    @Override
    public void setBounds(int x2, int y2, int width2, int height2) {
        int roundedWidth = width2;
        int roundedHeight = height2;
        if (this.isInited) {
            roundedWidth = this.roundSize(width2);
            roundedHeight = this.roundSize(height2);
        }
        super.setBounds(x2, y2, roundedWidth, roundedHeight);
        this.backedLayer.setSize(roundedWidth, roundedHeight);
        Redrawer redrawer = this.redrawer;
        if (redrawer != null) {
            redrawer.syncSize();
        }
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Redrawer redrawer;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paint(g);
        if (this.backedLayer.checkContentScale()) {
            this.notifyChange(PropertyKind.ContentScale);
        }
        if ((redrawer = this.redrawer) != null) {
            redrawer.syncSize();
        }
        if (this.isRendering) {
            redrawer = this.redrawer;
            if (redrawer != null) {
                redrawer.needRedraw();
            }
        } else {
            redrawer = this.redrawer;
            if (redrawer != null) {
                redrawer.redrawImmediately();
            }
        }
    }

    @Override
    public void enableInputMethods(boolean enable) {
        this.backedLayer.enableInputMethods(enable);
    }

    @Override
    @NotNull
    public InputMethodListener[] getInputMethodListeners() {
        InputMethodListener[] inputMethodListenerArray = this.backedLayer.getInputMethodListeners();
        Intrinsics.checkNotNullExpressionValue((Object)inputMethodListenerArray, (String)"backedLayer.getInputMethodListeners()");
        return inputMethodListenerArray;
    }

    @Override
    protected void processInputMethodEvent(@Nullable InputMethodEvent e) {
        this.backedLayer.doProcessInputMethodEvent(e);
    }

    @Override
    public void requestFocus() {
        this.backedLayer.requestFocus();
    }

    @Override
    public void requestFocus(@Nullable FocusEvent.Cause cause) {
        this.backedLayer.requestFocus(cause);
    }

    @Override
    public void addInputMethodListener(@NotNull InputMethodListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        super.addInputMethodListener(l);
        this.backedLayer.addInputMethodListener(l);
    }

    @Override
    public void addMouseListener(@NotNull MouseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.backedLayer.addMouseListener(l);
    }

    @Override
    public void addMouseMotionListener(@NotNull MouseMotionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.backedLayer.addMouseMotionListener(l);
    }

    @Override
    public void addMouseWheelListener(@NotNull MouseWheelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.backedLayer.addMouseWheelListener(l);
    }

    @Override
    public void addKeyListener(@NotNull KeyListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.backedLayer.addKeyListener(l);
    }

    @Override
    public void removeInputMethodListener(@NotNull InputMethodListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        super.removeInputMethodListener(l);
        this.backedLayer.removeInputMethodListener(l);
    }

    @Override
    public void removeMouseListener(@NotNull MouseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.backedLayer.removeMouseListener(l);
    }

    @Override
    public void removeMouseMotionListener(@NotNull MouseMotionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.backedLayer.removeMouseMotionListener(l);
    }

    @Override
    public void removeMouseWheelListener(@NotNull MouseWheelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.backedLayer.removeMouseWheelListener(l);
    }

    @Override
    public void removeKeyListener(@NotNull KeyListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.backedLayer.removeKeyListener(l);
    }

    @Override
    public void setFocusTraversalKeysEnabled(boolean focusTraversalKeysEnabled) {
        this.backedLayer.setFocusTraversalKeysEnabled(focusTraversalKeysEnabled);
    }

    public final void needRedraw() {
        boolean bl = SwingUtilities.isEventDispatchThread();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Method should be called from AWT event dispatch thread";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = !this.isDisposed;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "SkiaLayer is disposed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Redrawer redrawer = this.redrawer;
        if (redrawer != null) {
            redrawer.needRedraw();
        }
    }

    private static /* synthetic */ void getFpsCounter$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update$skiko(long nanoTime) {
        Object object;
        boolean bl = SwingUtilities.isEventDispatchThread();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Method should be called from AWT event dispatch thread";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = !this.isDisposed;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "SkiaLayer is disposed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        FrameWatcher.INSTANCE.nextFrame();
        FPSCounter fPSCounter = this.fpsCounter;
        if (fPSCounter != null) {
            fPSCounter.tick();
        }
        int pictureWidth = RangesKt.coerceAtLeast((int)((int)((float)this.getWidth() * this.getContentScale())), (int)0);
        int pictureHeight = RangesKt.coerceAtLeast((int)((int)((float)this.getHeight() * this.getContentScale())), (int)0);
        Rect bounds2 = Rect.Companion.makeWH(pictureWidth, pictureHeight);
        PictureRecorder pictureRecorder = this.pictureRecorder;
        Intrinsics.checkNotNull((Object)pictureRecorder);
        Canvas canvas = pictureRecorder.beginRecording(bounds2);
        for (ClipRectangle component : this.clipComponents) {
            this.clipRectBy(canvas, component);
        }
        try {
            this.isRendering = true;
            object = this.skikoView;
            if (object == null) {
            } else {
                object.onRender(canvas, pictureWidth, pictureHeight, nanoTime);
            }
        }
        finally {
            this.isRendering = false;
        }
        if (!this.isDisposed) {
            object = this.pictureLock;
            boolean bl6 = false;
            boolean bl7 = false;
            synchronized (object) {
                Picture picture;
                boolean bl8 = false;
                PictureHolder pictureHolder = this.picture;
                if (pictureHolder != null && (picture = pictureHolder.getInstance()) != null) {
                    picture.close();
                }
                PictureRecorder pictureRecorder2 = this.pictureRecorder;
                Intrinsics.checkNotNull((Object)pictureRecorder2);
                Picture picture2 = pictureRecorder2.finishRecordingAsPicture();
                this.picture = new PictureHolder(picture2, pictureWidth, pictureHeight);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final void inDrawScope$skiko(@NotNull Function0<Unit> body) {
        block5: {
            Intrinsics.checkNotNullParameter(body, (String)"body");
            boolean $i$f$inDrawScope$skiko = false;
            boolean bl = SwingUtilities.isEventDispatchThread();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Method should be called from AWT event dispatch thread";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            bl = !this.isDisposed;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "SkiaLayer is disposed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            try {
                body.invoke();
            }
            catch (CancellationException cancellationException) {
            }
            catch (RenderException e) {
                if (this.isDisposed) break block5;
                Object object = e.getMessage();
                bl3 = false;
                System.out.println(object);
                this.findNextWorkingRenderApi();
                object = this.getRedrawer$skiko();
                if (object == null) break block5;
                object.redrawImmediately();
            }
        }
    }

    public final void draw$skiko(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        boolean bl = !this.isDisposed;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "SkiaLayer is disposed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.lockPicture((Function1)new Function1<PictureHolder, Canvas>(canvas){
            final /* synthetic */ Canvas $canvas;
            {
                this.$canvas = $canvas;
                super(1);
            }

            @NotNull
            public final Canvas invoke(@NotNull PictureHolder it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$canvas.drawPicture(it.getInstance());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T lockPicture(Function1<? super PictureHolder, ? extends T> action) {
        Object object;
        Object object2 = this.pictureLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object2) {
            boolean bl3 = false;
            PictureHolder picture = this.picture;
            object = picture != null ? action.invoke((Object)picture) : null;
        }
        return (T)object;
    }

    @Nullable
    public final Bitmap screenshot() {
        boolean bl = !this.isDisposed;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "SkiaLayer is disposed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return (Bitmap)this.lockPicture(screenshot.2.INSTANCE);
    }

    private final void clipRectBy(Canvas $this$clipRectBy, ClipRectangle rectangle) {
        float dpi = this.getContentScale();
        $this$clipRectBy.clipRect(Rect.Companion.makeLTRB(rectangle.getX() * dpi, rectangle.getY() * dpi, (rectangle.getX() + rectangle.getWidth()) * dpi, (rectangle.getY() + rectangle.getHeight()) * dpi), ClipMode.DIFFERENCE, true);
    }

    private final int roundSize(int value) {
        float rounded = (float)value * this.getContentScale();
        float diff = rounded - (float)((int)rounded);
        rounded = diff > 0.4f && diff < 0.6f ? (float)value + 1.0f : (float)value;
        return (int)rounded;
    }

    private static final void _init_$lambda-0(SkiaLayer this$0, HierarchyEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ((it.getChangeFlags() & 4L) != 0L) {
            this$0.checkShowing();
        }
    }

    static {
        Library.INSTANCE.load();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/skiko/SkiaLayer$Companion;", "", "()V", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/skiko/SkiaLayer$PropertyKind;", "", "(Ljava/lang/String;I)V", "Renderer", "ContentScale", "skiko"})
    public static final class PropertyKind
    extends Enum<PropertyKind> {
        public static final /* enum */ PropertyKind Renderer = new PropertyKind();
        public static final /* enum */ PropertyKind ContentScale = new PropertyKind();
        private static final /* synthetic */ PropertyKind[] $VALUES;

        public static PropertyKind[] values() {
            return (PropertyKind[])$VALUES.clone();
        }

        public static PropertyKind valueOf(String value) {
            return Enum.valueOf(PropertyKind.class, value);
        }

        static {
            $VALUES = propertyKindArray = new PropertyKind[]{PropertyKind.Renderer, PropertyKind.ContentScale};
        }
    }
}

