/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0002J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u001b2\u0006\u0010\u001c\u001a\u00020\u0012J\u0017\u0010\u001d\u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0000\u00a2\u0006\u0002\b J\u0018\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0004H\u0002J\u0018\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\bH\u0002J!\u0010!\u001a\u0004\u0018\u00010\b2\u0006\u0010\"\u001a\u00020\u001f2\b\u0010#\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010$R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u0011\u0010\u000e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006\u00a8\u0006%"}, d2={"Lorg/jetbrains/skiko/SkikoProperties;", "", "()V", "fpsEnabled", "", "getFpsEnabled", "()Z", "fpsLongFramesMillis", "", "getFpsLongFramesMillis", "()Ljava/lang/Double;", "Ljava/lang/Double;", "fpsLongFramesShow", "getFpsLongFramesShow", "fpsPeriodSeconds", "getFpsPeriodSeconds", "()D", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "vsyncEnabled", "getVsyncEnabled", "vsyncFramelimitFallbackEnabled", "getVsyncFramelimitFallbackEnabled", "bestRenderApiForCurrentOS", "fallbackRenderApiQueue", "", "initialApi", "parseRenderApi", "text", "", "parseRenderApi$skiko", "property", "name", "default", "(Ljava/lang/String;Ljava/lang/Double;)Ljava/lang/Double;", "skiko"})
public final class SkikoProperties {
    @NotNull
    public static final SkikoProperties INSTANCE = new SkikoProperties();
    private static final boolean vsyncEnabled = INSTANCE.property("skiko.vsync.enabled", true);
    private static final boolean vsyncFramelimitFallbackEnabled = INSTANCE.property("skiko.vsync.framelimit.fallback.enabled", true);
    private static final boolean fpsEnabled = INSTANCE.property("skiko.fps.enabled", false);
    private static final double fpsPeriodSeconds = INSTANCE.property("skiko.fps.periodSeconds", 2.0);
    private static final boolean fpsLongFramesShow = INSTANCE.property("skiko.fps.longFrames.show", false);
    @Nullable
    private static final Double fpsLongFramesMillis = INSTANCE.property("skiko.fps.longFrames.millis", null);

    private SkikoProperties() {
    }

    public final boolean getVsyncEnabled() {
        return vsyncEnabled;
    }

    public final boolean getVsyncFramelimitFallbackEnabled() {
        return vsyncFramelimitFallbackEnabled;
    }

    public final boolean getFpsEnabled() {
        return fpsEnabled;
    }

    public final double getFpsPeriodSeconds() {
        return fpsPeriodSeconds;
    }

    public final boolean getFpsLongFramesShow() {
        return fpsLongFramesShow;
    }

    @Nullable
    public final Double getFpsLongFramesMillis() {
        return fpsLongFramesMillis;
    }

    @NotNull
    public final GraphicsApi getRenderApi() {
        String environment = System.getenv("SKIKO_RENDER_API");
        String property = System.getProperty("skiko.renderApi");
        return environment != null ? this.parseRenderApi$skiko(environment) : this.parseRenderApi$skiko(property);
    }

    @NotNull
    public final GraphicsApi parseRenderApi$skiko(@Nullable String text) {
        block25: {
            String string = text;
            if (string == null) break block25;
            int n = -1;
            switch (string.hashCode()) {
                case -1019861004: {
                    if (string.equals("SOFTWARE_FAST")) {
                        n = 1;
                    }
                    break;
                }
                case -907020006: {
                    if (string.equals("SOFTWARE_COMPAT")) {
                        n = 2;
                    }
                    break;
                }
                case -1957249873: {
                    if (string.equals("OPENGL")) {
                        n = 3;
                    }
                    break;
                }
                case 1028669466: {
                    if (string.equals("DIRECT3D")) {
                        n = 4;
                    }
                    break;
                }
                case 73249511: {
                    if (string.equals("METAL")) {
                        n = 5;
                    }
                    break;
                }
                case 2101957031: {
                    if (string.equals("SOFTWARE")) {
                        n = 1;
                    }
                    break;
                }
                case 1644349757: {
                    if (string.equals("DIRECT_SOFTWARE")) {
                        n = 1;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    return GraphicsApi.SOFTWARE_COMPAT;
                }
                case 1: {
                    return GraphicsApi.SOFTWARE_FAST;
                }
                case 3: {
                    return GraphicsApi.OPENGL;
                }
                case 4: {
                    if (OsArch_jvmKt.getHostOs() != OS.Windows) {
                        throw new Exception(OsArch_jvmKt.getHostOs() + " does not support DirectX rendering API.");
                    }
                    return GraphicsApi.DIRECT3D;
                }
                case 5: {
                    if (OsArch_jvmKt.getHostOs() != OS.MacOS) {
                        throw new Exception(OsArch_jvmKt.getHostOs() + " does not support Metal rendering API.");
                    }
                    return GraphicsApi.METAL;
                }
            }
        }
        return this.bestRenderApiForCurrentOS();
    }

    private final GraphicsApi bestRenderApiForCurrentOS() {
        OS oS = OsArch_jvmKt.getHostOs();
        int n = WhenMappings.$EnumSwitchMapping$0[oS.ordinal()];
        switch (n) {
            case 1: {
                return GraphicsApi.METAL;
            }
            case 2: {
                return GraphicsApi.OPENGL;
            }
            case 3: {
                return GraphicsApi.DIRECT3D;
            }
            case 4: 
            case 5: {
                String string = "commonize me";
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public final List<GraphicsApi> fallbackRenderApiQueue(@NotNull GraphicsApi initialApi) {
        List list;
        Intrinsics.checkNotNullParameter((Object)((Object)initialApi), (String)"initialApi");
        OS oS = OsArch_jvmKt.getHostOs();
        int n = WhenMappings.$EnumSwitchMapping$0[oS.ordinal()];
        switch (n) {
            case 2: {
                GraphicsApi[] graphicsApiArray = new GraphicsApi[]{GraphicsApi.OPENGL, GraphicsApi.SOFTWARE_FAST, GraphicsApi.SOFTWARE_COMPAT};
                list = CollectionsKt.listOf((Object[])graphicsApiArray);
                break;
            }
            case 1: {
                GraphicsApi[] graphicsApiArray = new GraphicsApi[]{GraphicsApi.METAL, GraphicsApi.SOFTWARE_COMPAT};
                list = CollectionsKt.listOf((Object[])graphicsApiArray);
                break;
            }
            case 3: {
                GraphicsApi[] graphicsApiArray = new GraphicsApi[]{GraphicsApi.DIRECT3D, GraphicsApi.OPENGL, GraphicsApi.SOFTWARE_FAST, GraphicsApi.SOFTWARE_COMPAT};
                list = CollectionsKt.listOf((Object[])graphicsApiArray);
                break;
            }
            case 4: 
            case 5: {
                String string = "commonize me";
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List fallbackApis = list;
        int indexOfInitialApi = fallbackApis.indexOf((Object)initialApi);
        if (indexOfInitialApi >= 0) {
            fallbackApis = CollectionsKt.drop((Iterable)fallbackApis, (int)(indexOfInitialApi + 1));
        }
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((Object)initialApi)), (Iterable)fallbackApis);
    }

    private final boolean property(String name, boolean bl) {
        boolean bl2;
        String string = System.getProperty(name);
        if (string == null) {
            bl2 = bl;
        } else {
            boolean bl3;
            String string2 = string;
            boolean bl4 = false;
            bl2 = bl3 = Boolean.parseBoolean(string2);
        }
        return bl2;
    }

    private final double property(String name, double d) {
        double d2;
        String string = System.getProperty(name);
        if (string == null) {
            d2 = d;
        } else {
            double d3;
            String string2 = string;
            boolean bl = false;
            d2 = d3 = Double.parseDouble(string2);
        }
        return d2;
    }

    private final Double property(String name, Double d) {
        Double d2;
        String string = System.getProperty(name);
        if (string == null) {
            d2 = d;
        } else {
            Double d3;
            String string2 = string;
            boolean bl = false;
            d2 = d3 = Double.valueOf(Double.parseDouble(string2));
        }
        return d2;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            nArray[OS.MacOS.ordinal()] = 1;
            nArray[OS.Linux.ordinal()] = 2;
            nArray[OS.Windows.ordinal()] = 3;
            nArray[OS.JS.ordinal()] = 4;
            nArray[OS.Ios.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

