/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import java.lang.ref.Reference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.impl.NativeKt;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.context.JvmContextHandler;
import org.jetbrains.skiko.redrawer.Direct3DRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0014J\u0019\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0082 J\b\u0010\u0019\u001a\u00020\u0014H\u0014J\b\u0010\u001a\u001a\u00020\u000eH\u0014J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006 "}, d2={"Lorg/jetbrains/skiko/context/Direct3DContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "bufferCount", "", "currentHeight", "currentWidth", "directXRedrawer", "Lorg/jetbrains/skiko/redrawer/Direct3DRedrawer;", "getDirectXRedrawer", "()Lorg/jetbrains/skiko/redrawer/Direct3DRedrawer;", "isD3DInited", "", "surfaces", "", "Lorg/jetbrains/skia/Surface;", "[Lorg/jetbrains/skia/Surface;", "disposeCanvas", "", "flush", "context", "", "surface", "initCanvas", "initContext", "isSizeChanged", "width", "height", "rendererInfo", "", "skiko"})
public final class Direct3DContextHandler
extends JvmContextHandler {
    private final int bufferCount;
    @NotNull
    private Surface[] surfaces;
    private int currentWidth;
    private int currentHeight;
    private boolean isD3DInited;

    public Direct3DContextHandler(@NotNull SkiaLayer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super(layer);
        this.bufferCount = 2;
        this.surfaces = new Surface[this.bufferCount];
    }

    private final Direct3DRedrawer getDirectXRedrawer() {
        Redrawer redrawer = this.getLayer().getRedrawer$skiko();
        Intrinsics.checkNotNull((Object)redrawer);
        return (Direct3DRedrawer)redrawer;
    }

    @Override
    protected boolean initContext() {
        try {
            if (this.getContext() == null) {
                this.setContext(this.getDirectXRedrawer().makeContext());
                if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true")) {
                    String string = this.rendererInfo();
                    boolean bl = false;
                    System.out.println((Object)string);
                }
            }
        }
        catch (Exception e) {
            String string = e.getMessage() + "\nFailed to create Skia Direct3D context!";
            boolean bl = false;
            System.out.println((Object)string);
            return false;
        }
        return true;
    }

    private final boolean isSizeChanged(int width2, int height2) {
        if (width2 != this.currentWidth || height2 != this.currentHeight) {
            this.currentWidth = width2;
            this.currentHeight = height2;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initCanvas() {
        int h;
        float scale = this.getLayer().getContentScale();
        int w = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)0);
        if (this.isSizeChanged(w, h = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)0))) {
            this.disposeCanvas();
            DirectContext directContext = this.getContext();
            if (directContext != null) {
                directContext.flush();
            }
            if (!this.isD3DInited) {
                this.getDirectXRedrawer().initSwapChain();
            } else {
                this.getDirectXRedrawer().resizeBuffers(w, h);
            }
            try {
                int n = 0;
                int n2 = this.bufferCount - 1;
                if (n <= n2) {
                    int bufferIndex;
                    do {
                        bufferIndex = n++;
                        Direct3DRedrawer direct3DRedrawer = this.getDirectXRedrawer();
                        DirectContext directContext2 = this.getContext();
                        Intrinsics.checkNotNull((Object)directContext2);
                        this.surfaces[bufferIndex] = direct3DRedrawer.makeSurface(NativeKt.getPtr(directContext2), w, h, bufferIndex);
                    } while (bufferIndex != n2);
                }
            }
            finally {
                DirectContext directContext3 = this.getContext();
                Intrinsics.checkNotNull((Object)directContext3);
                Reference.reachabilityFence(directContext3);
            }
            if (!this.isD3DInited) {
                this.isD3DInited = true;
                this.getDirectXRedrawer().initFence();
            }
        }
        this.setSurface(this.surfaces[this.getDirectXRedrawer().getBufferIndex()]);
        Surface surface = this.getSurface();
        Intrinsics.checkNotNull((Object)surface);
        this.setCanvas(surface.getCanvas());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flush() {
        try {
            DirectContext directContext = this.getContext();
            Intrinsics.checkNotNull((Object)directContext);
            long l = NativeKt.getPtr(directContext);
            Surface surface = this.getSurface();
            Intrinsics.checkNotNull((Object)surface);
            this.flush(l, NativeKt.getPtr(surface));
        }
        finally {
            DirectContext directContext = this.getContext();
            Intrinsics.checkNotNull((Object)directContext);
            Reference.reachabilityFence(directContext);
            Surface surface = this.getSurface();
            Intrinsics.checkNotNull((Object)surface);
            Reference.reachabilityFence(surface);
        }
    }

    @Override
    protected void disposeCanvas() {
        int n = 0;
        int n2 = this.bufferCount;
        if (n < n2) {
            do {
                int bufferIndex;
                Surface surface;
                if ((surface = this.surfaces[bufferIndex = n++]) == null) continue;
                surface.close();
            } while (n < n2);
        }
    }

    @Override
    @NotNull
    public String rendererInfo() {
        return super.rendererInfo() + "Video card: " + this.getDirectXRedrawer().getAdapterName() + "\nTotal VRAM: " + this.getDirectXRedrawer().getAdapterMemorySize() / (long)1024 / (long)1024 + " MB\n";
    }

    private final native void flush(long var1, long var3);
}

