/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.redrawer;

import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.swing.SwingDispatcherKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skiko.FrameDispatcher;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.context.AngleContextHandler;
import org.jetbrains.skiko.redrawer.Redrawer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0086 J\u0006\u0010\u0015\u001a\u00020\nJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0011\u0010\u0018\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0086 J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\u0006\u0010\u001a\u001a\u00020\u0017J\u0019\u0010\u001a\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u000eH\u0086 J\u0011\u0010\u001c\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0086 J!\u0010\u001d\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0086 J\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ\b\u0010%\u001a\u00020\u0017H\u0016J\b\u0010&\u001a\u00020\u0017H\u0016J!\u0010'\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0086 J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006*"}, d2={"Lorg/jetbrains/skiko/redrawer/AngleRedrawer;", "Lorg/jetbrains/skiko/redrawer/Redrawer;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "properties", "Lorg/jetbrains/skiko/SkiaLayerProperties;", "(Lorg/jetbrains/skiko/SkiaLayer;Lorg/jetbrains/skiko/SkiaLayerProperties;)V", "contextHandler", "Lorg/jetbrains/skiko/context/AngleContextHandler;", "device", "", "frameDispatcher", "Lorg/jetbrains/skiko/FrameDispatcher;", "isDisposed", "", "renderInfo", "", "getRenderInfo", "()Ljava/lang/String;", "createAngleDevice", "contentHandle", "createDevice", "dispose", "", "disposeDevice", "draw", "finishFrame", "isVsyncEnabled", "makeAngleContext", "makeAngleRenderTarget", "width", "", "height", "makeContext", "Lorg/jetbrains/skia/DirectContext;", "makeRenderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "needRedraw", "redrawImmediately", "resizeBuffers", "update", "nanoTime", "skiko"})
public final class AngleRedrawer
implements Redrawer {
    @NotNull
    private final SkiaLayer layer;
    @NotNull
    private final SkiaLayerProperties properties;
    @NotNull
    private final AngleContextHandler contextHandler;
    private boolean isDisposed;
    private long device;
    @NotNull
    private final FrameDispatcher frameDispatcher;

    public AngleRedrawer(@NotNull SkiaLayer layer, @NotNull SkiaLayerProperties properties) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.layer = layer;
        this.properties = properties;
        this.contextHandler = new AngleContextHandler(this.layer);
        this.frameDispatcher = new FrameDispatcher((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE), (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AngleRedrawer this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (AngleRedrawer.access$getLayer$p(this.this$0).isShowing()) {
                            AngleRedrawer.access$update(this.this$0, System.nanoTime());
                            AngleRedrawer.access$draw(this.this$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    @NotNull
    public String getRenderInfo() {
        return this.contextHandler.rendererInfo();
    }

    @Override
    public void dispose() {
        this.frameDispatcher.cancel();
        this.contextHandler.dispose();
        this.disposeDevice(this.device);
        this.isDisposed = true;
    }

    @Override
    public void needRedraw() {
        boolean bl = !this.isDisposed;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "AngleRedrawer is disposed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.frameDispatcher.scheduleFrame();
    }

    @Override
    public void redrawImmediately() {
        boolean bl = !this.isDisposed;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "AngleRedrawer is disposed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.update(System.nanoTime());
        this.draw();
    }

    private final void update(long nanoTime) {
        this.layer.update$skiko(nanoTime);
    }

    private final void draw() {
        this.contextHandler.draw();
    }

    public final long createDevice() {
        this.device = this.createAngleDevice(this.layer.getContentHandle());
        return this.device;
    }

    @NotNull
    public final DirectContext makeContext() {
        return new DirectContext(this.makeAngleContext(this.device));
    }

    @NotNull
    public final BackendRenderTarget makeRenderTarget(int width2, int height2) {
        return new BackendRenderTarget(this.makeAngleRenderTarget(this.device, width2, height2));
    }

    public final void finishFrame() {
        this.finishFrame(this.device, this.properties.isVsyncEnabled());
    }

    public final native long createAngleDevice(long var1);

    public final native long makeAngleContext(long var1);

    public final native long makeAngleRenderTarget(long var1, int var3, int var4);

    public final native void resizeBuffers(long var1, int var3, int var4);

    public final native void finishFrame(long var1, boolean var3);

    public final native void disposeDevice(long var1);

    @Override
    public void syncSize() {
        Redrawer.DefaultImpls.syncSize(this);
    }

    public static final /* synthetic */ SkiaLayer access$getLayer$p(AngleRedrawer $this) {
        return $this.layer;
    }

    public static final /* synthetic */ void access$update(AngleRedrawer $this, long nanoTime) {
        $this.update(nanoTime);
    }

    public static final /* synthetic */ void access$draw(AngleRedrawer $this) {
        $this.draw();
    }
}

