/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.awt.color.ColorSpace;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorType;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.Pixmap;
import org.jetbrains.skia.impl.BufferUtil;
import org.jetbrains.skiko.DirectDataBuffer;
import org.jetbrains.skiko.SkikoInputEvent;
import org.jetbrains.skiko.SkikoKeyboardEvent;
import org.jetbrains.skiko.SkikoKeyboardEventKind;
import org.jetbrains.skiko.SkikoPointerEvent;
import org.jetbrains.skiko.SkikoPointerEventKind;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0007\u001a\u000e\u0010\u0000\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\n*\u00020\u000b\u001a\n\u0010\f\u001a\u00020\u000b*\u00020\n\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000b\u00a8\u0006\u000f"}, d2={"toSkikoEvent", "Lorg/jetbrains/skiko/SkikoInputEvent;", "e", "Ljava/awt/event/InputMethodEvent;", "Lorg/jetbrains/skiko/SkikoKeyboardEvent;", "Ljava/awt/event/KeyEvent;", "Lorg/jetbrains/skiko/SkikoPointerEvent;", "Ljava/awt/event/MouseEvent;", "Ljava/awt/event/MouseWheelEvent;", "toBitmap", "Lorg/jetbrains/skia/Bitmap;", "Ljava/awt/image/BufferedImage;", "toBufferedImage", "toImage", "Lorg/jetbrains/skia/Image;", "skiko"})
public final class ConvertorsKt {
    @NotNull
    public static final BufferedImage toBufferedImage(@NotNull Bitmap $this$toBufferedImage) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)$this$toBufferedImage, (String)"<this>");
        Pixmap pixmap = $this$toBufferedImage.peekPixels();
        Intrinsics.checkNotNull((Object)pixmap);
        long pixelsNativePointer = pixmap.getAddr();
        ByteBuffer pixelsBuffer = BufferUtil.INSTANCE.getByteBufferFromPointer(pixelsNativePointer, $this$toBufferedImage.getRowBytes() * $this$toBufferedImage.getHeight());
        ColorType colorType = $this$toBufferedImage.getColorInfo().getColorType();
        int n = WhenMappings.$EnumSwitchMapping$0[colorType.ordinal()];
        switch (n) {
            case 1: {
                int[] nArray2 = new int[]{0, 1, 2, 3};
                nArray = nArray2;
                break;
            }
            case 2: {
                int[] nArray2 = new int[]{2, 1, 0, 3};
                nArray = nArray2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported color type " + $this$toBufferedImage.getColorInfo().getColorType());
            }
        }
        int[] order = nArray;
        WritableRaster raster = Raster.createInterleavedRaster(new DirectDataBuffer(pixelsBuffer), $this$toBufferedImage.getWidth(), $this$toBufferedImage.getHeight(), $this$toBufferedImage.getWidth() * 4, 4, order, null);
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
        ColorModel colorModel2 = colorModel;
        WritableRaster writableRaster = raster;
        Intrinsics.checkNotNull((Object)writableRaster);
        return new BufferedImage(colorModel2, writableRaster, false, null);
    }

    @NotNull
    public static final Bitmap toBitmap(@NotNull BufferedImage $this$toBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$toBitmap, (String)"<this>");
        int bytesPerPixel = 4;
        byte[] pixels = new byte[$this$toBitmap.getWidth() * $this$toBitmap.getHeight() * bytesPerPixel];
        int k = 0;
        int n = 0;
        int n2 = $this$toBitmap.getHeight();
        if (n < n2) {
            do {
                int y2 = n++;
                int n3 = 0;
                int n4 = $this$toBitmap.getWidth();
                if (n3 >= n4) continue;
                do {
                    int x2 = n3++;
                    int argb = $this$toBitmap.getRGB(x2, y2);
                    int a = argb >> 24 & 0xFF;
                    int r = argb >> 16 & 0xFF;
                    int g = argb >> 8 & 0xFF;
                    int b = argb >> 0 & 0xFF;
                    int n5 = k;
                    k = n5 + 1;
                    pixels[n5] = (byte)b;
                    n5 = k;
                    k = n5 + 1;
                    pixels[n5] = (byte)g;
                    n5 = k;
                    k = n5 + 1;
                    pixels[n5] = (byte)r;
                    n5 = k;
                    k = n5 + 1;
                    pixels[n5] = (byte)a;
                } while (n3 < n4);
            } while (n < n2);
        }
        Bitmap bitmap = new Bitmap();
        bitmap.allocPixels(ImageInfo.Companion.makeS32($this$toBitmap.getWidth(), $this$toBitmap.getHeight(), ColorAlphaType.UNPREMUL));
        bitmap.installPixels(pixels);
        return bitmap;
    }

    @NotNull
    public static final Image toImage(@NotNull BufferedImage $this$toImage) {
        Intrinsics.checkNotNullParameter((Object)$this$toImage, (String)"<this>");
        return Image.Companion.makeFromBitmap(ConvertorsKt.toBitmap($this$toImage));
    }

    @NotNull
    public static final SkikoPointerEvent toSkikoEvent(@NotNull MouseEvent e) {
        SkikoPointerEventKind skikoPointerEventKind;
        int n;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        double d = e.getX();
        double d2 = e.getY();
        int n2 = e.getButton();
        switch (n2) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            default: {
                n = 0;
            }
        }
        n2 = e.getID();
        switch (n2) {
            case 501: {
                skikoPointerEventKind = SkikoPointerEventKind.DOWN;
                break;
            }
            case 502: {
                skikoPointerEventKind = SkikoPointerEventKind.UP;
                break;
            }
            case 506: {
                skikoPointerEventKind = SkikoPointerEventKind.DRAG;
                break;
            }
            case 503: {
                skikoPointerEventKind = SkikoPointerEventKind.MOVE;
                break;
            }
            case 504: {
                skikoPointerEventKind = SkikoPointerEventKind.ENTER;
                break;
            }
            case 505: {
                skikoPointerEventKind = SkikoPointerEventKind.EXIT;
                break;
            }
            default: {
                skikoPointerEventKind = SkikoPointerEventKind.UNKNOWN;
            }
        }
        return new SkikoPointerEvent(d, d2, n, skikoPointerEventKind, e);
    }

    @NotNull
    public static final SkikoPointerEvent toSkikoEvent(@NotNull MouseWheelEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        int n = e.getID();
        return new SkikoPointerEvent(e.getX(), e.getY(), 0, n == 507 ? SkikoPointerEventKind.SCROLL : SkikoPointerEventKind.UNKNOWN, e);
    }

    @NotNull
    public static final SkikoKeyboardEvent toSkikoEvent(@NotNull KeyEvent e) {
        SkikoKeyboardEventKind skikoKeyboardEventKind;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        int n = e.getKeyCode();
        int n2 = e.getID();
        switch (n2) {
            case 401: {
                skikoKeyboardEventKind = SkikoKeyboardEventKind.DOWN;
                break;
            }
            case 402: {
                skikoKeyboardEventKind = SkikoKeyboardEventKind.UP;
                break;
            }
            case 400: {
                skikoKeyboardEventKind = SkikoKeyboardEventKind.TYPE;
                break;
            }
            default: {
                skikoKeyboardEventKind = SkikoKeyboardEventKind.UNKNOWN;
            }
        }
        return new SkikoKeyboardEvent(n, skikoKeyboardEventKind, e);
    }

    @NotNull
    public static final SkikoInputEvent toSkikoEvent(@NotNull InputMethodEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new SkikoInputEvent("", e);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColorType.values().length];
            nArray[ColorType.RGB_888X.ordinal()] = 1;
            nArray[ColorType.BGRA_8888.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

