package org.jetbrains.skiko

actual enum class SkikoKey(actual val platformKeyCode: Int) {
    KEY_UNKNOWN(-1),
    KEY_A(65),
    KEY_S(83),
    KEY_D(68),
    KEY_F(70),
    KEY_H(72),
    KEY_G(71),
    KEY_Z(90),
    KEY_X(88),
    KEY_C(67),
    KEY_V(86),
    KEY_B(66),
    KEY_Q(81),
    KEY_W(87),
    KEY_E(69),
    KEY_R(82),
    KEY_Y(89),
    KEY_T(54),
    KEY_U(85),
    KEY_I(73),
    KEY_P(80),
    KEY_L(76),
    KEY_J(74),
    KEY_K(75),
    KEY_N(78),
    KEY_M(77),
    KEY_O(79),
    KEY_1(49),
    KEY_2(50),
    KEY_3(51),
    KEY_4(52),
    KEY_5(53),
    KEY_6(54),
    KEY_7(55),
    KEY_8(56),
    KEY_9(57),
    KEY_0(48),
    KEY_CLOSE_BRACKET(221),
    KEY_OPEN_BRACKET(219),
    KEY_QUOTE(222),
    KEY_SEMICOLON(59),
    KEY_SLASH(191),
    KEY_COMMA(188),
    KEY_BACKSLASH(220),
    KEY_PERIOD(190),
    KEY_BACK_QUOTE(192),
    KEY_EQUALS(61),
    KEY_MINUS(173),
    KEY_ENTER(13),
    KEY_ESCAPE(27),
    KEY_TAB(9),
    KEY_BACKSPACE(8),
    KEY_SPACE(32),
    KEY_CAPSLOCK(20),
    KEY_LEFT_META(224),
    KEY_LEFT_SHIFT(16),
    KEY_LEFT_ALT(18),
    KEY_LEFT_CONTROL(17),
    KEY_RIGHT_META(0x80000000.toInt() or 224),
    KEY_RIGHT_SHIFT(0x80000000.toInt() or 16),
    KEY_RIGHT_ALT(225),
    KEY_RIGHT_CONTROL(0x80000000.toInt() or 17),
    KEY_MENU(93),
    KEY_UP(38),
    KEY_DOWN(40),
    KEY_LEFT(37),
    KEY_RIGHT(39),
    KEY_F1(112),
    KEY_F2(113),
    KEY_F3(114),
    KEY_F4(115),
    KEY_F5(116),
    KEY_F6(117),
    KEY_F7(118),
    KEY_F8(119),
    KEY_F9(120),
    KEY_F10(121),
    KEY_F11(122),
    KEY_F12(123),
    KEY_PRINTSCEEN(44),
    KEY_SCROLL_LOCK(145),
    KEY_PAUSE(19),
    KEY_INSERT(45),
    KEY_HOME(36),
    KEY_PGUP(33),
    KEY_DELETE(46),
    KEY_END(35),
    KEY_PGDOWN(34),
    KEY_NUM_LOCK(144),
    KEY_NUMPAD_0(96),
    KEY_NUMPAD_1(97),
    KEY_NUMPAD_2(98),
    KEY_NUMPAD_3(99),
    KEY_NUMPAD_4(100),
    KEY_NUMPAD_5(101),
    KEY_NUMPAD_6(102),
    KEY_NUMPAD_7(103),
    KEY_NUMPAD_8(104),
    KEY_NUMPAD_9(105),
    KEY_NUMPAD_ENTER(14),
    KEY_NUMPAD_ADD(107),
    KEY_NUMPAD_SUBTRACT(109),
    KEY_NUMPAD_MULTIPLY(106),
    KEY_NUMPAD_DIVIDE(111),
    KEY_NUMPAD_DECIMAL(110);

    companion object {
        fun valueOf(platformKeyCode: Int): SkikoKey {
            return values().firstOrNull { it.platformKeyCode == platformKeyCode } ?: KEY_UNKNOWN
        }
    }
}
